<?php
session_start();
// Optional cek role disini kalau perlu

include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['aksi']) && $_POST['aksi'] === 'update_siswa') {
    $nomor = $_POST['nomor_registrasi'] ?? '';
    $nomor_sertifikat = $_POST['nomor_sertifikat'] ?? null;
    $sabuk = $_POST['sabuk'] ?? null;

    if (!$nomor) {
        echo json_encode(['status' => 'error', 'message' => 'Nomor registrasi diperlukan']);
        exit;
    }

    $fieldsToUpdate = [];
    $params = [];

    if ($nomor_sertifikat !== null) {
        $fieldsToUpdate[] = "nomor_sertifikat = ?";
        $params[] = $nomor_sertifikat;
    }
    if ($sabuk !== null) {
        $fieldsToUpdate[] = "sabuk = ?";
        $params[] = $sabuk;
    }

    if (empty($fieldsToUpdate)) {
        echo json_encode(['status' => 'error', 'message' => 'Tidak ada data untuk diupdate']);
        exit;
    }

    $params[] = $nomor;

    $sql = "UPDATE siswa SET " . implode(', ', $fieldsToUpdate) . " WHERE nomor_registrasi = ?";
    $stmt = $pdo->prepare($sql);

    if ($stmt->execute($params)) {
        echo json_encode(['status' => 'success', 'message' => 'Data berhasil diperbarui']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Gagal memperbarui data']);
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<title>MOMENTUM TAEKWONDO CLUB - Scanner & Update Data</title>
<script src="js/html5-qrcode.min.js"></script>
<style>
    body { font-family: Arial, sans-serif; margin: 20px; max-width: 700px; }
    #reader { width: 100%; max-width: 500px; margin: 0 auto 20px; }
    #info-siswa { display: none; background: #f9f9f9; padding: 15px; border-radius: 8px; }
    #info-siswa h2 { margin-top: 0; }
    table { border-collapse: collapse; width: 100%; margin-top: 10px; font-size: 14px; }
    th, td { border: 1px solid #ccc; padding: 8px; text-align: center; }
    th { background-color: #007BFF; color: white; }
    #btn-scan-ulang, #btn-update { margin-top: 20px; padding: 10px 15px; font-size: 16px; cursor: pointer; }

    #foto-sabuk-wrapper {
        display: flex;
        gap: 20px;
        align-items: center;
        margin-bottom: 15px;
    }
    .foto-siswa, .foto-sabuk {
        border: 1px solid #000;
        border-radius: 6px;
        background: #f0f0f0;
        overflow: hidden;
        flex-shrink: 0;
    }
    .foto-siswa {
        width: 120px;
        height: 140px;
    }
    .foto-siswa img, .foto-sabuk img {
        width: 100%;
        height: 100%;
        object-fit: contain;
    }
    .foto-sabuk {
        width: 100px;
        height: 100px;
    }
    label { display: block; margin-top: 10px; font-weight: bold; }
    select, input[type="text"] {
        width: 100%;
        padding: 8px;
        margin-top: 5px;
        box-sizing: border-box;
        border-radius: 4px;
        border: 1px solid #ccc;
        font-size: 16px;
    }
</style>
</head>
<body>

<h1>MOMENTUM TAEKWONDO CLUB</h1>

<div id="reader"></div>

<div id="info-siswa">
    <div id="foto-sabuk-wrapper">
        <div class="foto-siswa" id="foto-siswa">
            <img src="" alt="Foto Siswa" id="img-siswa">
        </div>
        <div class="foto-sabuk" id="foto-sabuk">
            <img src="" alt="Gambar Sabuk" id="img-sabuk">
        </div>
    </div>
    <h2 id="nama-siswa"></h2>
    <p><strong>Nomor Registrasi:</strong> <span id="nomor-siswa"></span></p>
    <p><strong>Dojang:</strong> <span id="dojang-siswa"></span></p>
    <p><strong>Alamat:</strong> <span id="alamat-siswa"></span></p>
    <p><strong>No HP:</strong> <span id="nohp-siswa"></span></p>
    <p><strong>Tanggal Lahir:</strong> <span id="ttl-siswa"></span></p>
    <p><strong>Nomor Sertifikat:</strong> <span id="nomor-sertifikat-siswa"></span></p>

    <h3>Status Iuran 1 Tahun Terakhir</h3>
    <table>
        <thead>
            <tr>
                <th>Bulan</th>
                <th>Tahun</th>
                <th>Status</th>
                <th>Tipe Pembayaran</th>
            </tr>
        </thead>
        <tbody id="tabel-iuran"></tbody>
    </table>

    <h3>Laporan Absensi</h3>
    <div style="overflow-x:auto;">
        <table id="tabel-absensi" style="width:100%; border-collapse: collapse;">
            <thead>
                <tr>
                    <th>Bulan</th>
                    <th>I</th><th>II</th><th>III</th><th>IV</th>
                    <th>V</th><th>VI</th><th>VII</th><th>VIII</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>

    <label for="input-sertifikat">Nomor Sertifikat</label>
    <input type="text" id="input-sertifikat" placeholder="Masukkan nomor sertifikat">

    <label for="select-sabuk">Sabuk</label>
    <select id="select-sabuk">
        <option value="Putih">Putih</option>
        <option value="Kuning">Kuning</option>
        <option value="Kuning Strip Hijau">Kuning Strip Hijau</option>
        <option value="Hijau">Hijau</option>
        <option value="Hijau Strip Biru">Hijau Strip Biru</option>
        <option value="Biru">Biru</option>
        <option value="Biru Strip Merah">Biru Strip Merah</option>
        <option value="Merah">Merah</option>
        <option value="Merah Strip 1">Merah Strip 1</option>
        <option value="Merah Strip 2">Merah Strip 2</option>
    </select>

    <button id="btn-update">Update Data</button>
    <button id="btn-scan-ulang">Scan Ulang</button>
</div>

<script>
const scanner = new Html5Qrcode("reader");
let lastResult = null;

const dojangMap = {
    'BWPK': 'Balai Warga Pondok Kelapa',
    'SDTS': 'SD Tiara School',
    'SDTK': 'SD Tunas Karya 2',
    'SMP6': 'SMPN 6 Jakarta',
    'SMA107': 'SMAN 107 Jakarta',
    'EPA': 'East Park Apartment',
    'RBHIN': 'RPTRA Bhineka (EPRA)',
    'ALAC': 'Alhuda Academy (EPRA)',
    'PKB': 'Pakubuwono (EPRA)',
    'SBSD': 'Sekolah Sinarmas BSD',
    'PRV': 'Private',
    'TMMLK': 'Taman Malaka'
};

const namaBulan = ['', 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
                   'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];

function resetScanner() {
    lastResult = null;
    document.getElementById('info-siswa').style.display = 'none';
    document.getElementById('reader').style.display = 'block';
    document.getElementById('img-siswa').src = '';
    document.getElementById('img-sabuk').src = '';
    document.getElementById('nama-siswa').textContent = '';
    document.getElementById('nomor-siswa').textContent = '';
    document.getElementById('dojang-siswa').textContent = '';
    document.getElementById('alamat-siswa').textContent = '';
    document.getElementById('nohp-siswa').textContent = '';
    document.getElementById('ttl-siswa').textContent = '';
	document.getElementById('nomor-sertifikat-siswa').textContent = '';
    document.getElementById('tabel-iuran').innerHTML = '';
    document.querySelector('#tabel-absensi tbody').innerHTML = '';

    document.getElementById('input-sertifikat').value = '';
    document.getElementById('select-sabuk').value = 'Putih';

    scanner.start(
        { facingMode: "environment" },
        { fps: 10, qrbox: 250 },
        onScanSuccess,
        onScanFailure
    ).catch(err => {
        console.error(err);
    });
}

function onScanSuccess(decodedText) {
    if (decodedText === lastResult) return;
    lastResult = decodedText;
    scanner.stop().then(() => {
        document.getElementById('reader').style.display = 'none';
        loadSiswaData(decodedText);
    }).catch(err => {
        console.error('Gagal stop scanner', err);
    });
}

function onScanFailure(error) {
    // Ignore scan failure
}

function loadSiswaData(nomor) {
    fetch(`get_data_siswa.php?nomor=${encodeURIComponent(nomor)}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                const siswa = data.siswa;
                const iuran = data.iuran;
                const absensi = data.absensi || [];

                const fotoPath = `uploads/foto/${encodeURIComponent(siswa.nomor_registrasi)}.jpg`;
                document.getElementById('img-siswa').src = fotoPath;

                let sabukRaw = siswa.sabuk || 'Putih';
                sabukRaw = sabukRaw.trim();
                let sabukFile = sabukRaw.toLowerCase().replace(/[\s-]/g, '_');
                document.getElementById('img-sabuk').src = `sabuk/${sabukFile}.png`;
                document.getElementById('img-sabuk').alt = `Sabuk ${sabukRaw}`;

                document.getElementById('nama-siswa').textContent = siswa.nama_lengkap;
                document.getElementById('nomor-siswa').textContent = siswa.nomor_registrasi;
                document.getElementById('dojang-siswa').textContent = dojangMap[siswa.kode_dojang] || siswa.kode_dojang;
                document.getElementById('alamat-siswa').textContent = siswa.alamat_lengkap;
                document.getElementById('nohp-siswa').textContent = siswa.no_hp;
                document.getElementById('ttl-siswa').textContent = siswa.tempat_tgl_lahir;
                document.getElementById('nomor-sertifikat-siswa').textContent = siswa.nomor_sertifikat || '';

                document.getElementById('input-sertifikat').value = siswa.nomor_sertifikat || '';
                document.getElementById('select-sabuk').value = siswa.sabuk || 'Putih';

                const tbodyIuran = document.getElementById('tabel-iuran');
                tbodyIuran.innerHTML = '';
                if (iuran.length === 0) {
                    tbodyIuran.innerHTML = '<tr><td colspan="4">Tidak ada data iuran</td></tr>';
                } else {
                    iuran.forEach(row => {
                        const tr = document.createElement('tr');
                        tr.innerHTML = `
                            <td>${row.bulan}</td>
                            <td>${row.tahun}</td>
                            <td>${row.status}</td>
                            <td>${row.tipe_pembayaran}</td>
                        `;
                        tbodyIuran.appendChild(tr);
                    });
                }

                renderAbsensi(absensi);

                document.getElementById('info-siswa').style.display = 'block';
            } else {
                alert(data.message || 'Gagal ambil data siswa');
                resetScanner();
            }
        })
        .catch(() => {
            alert('Error koneksi ke server.');
            resetScanner();
        });
}

function renderAbsensi(absensiData) {
    const tbody = document.querySelector('#tabel-absensi tbody');
    tbody.innerHTML = '';

    const abs = {};
    for (let b = 1; b <= 12; b++) {
        abs[b] = {};
        for (let p = 1; p <= 8; p++) {
            abs[b][p] = '';
        }
    }

    absensiData.forEach(item => {
        const bulan = parseInt(item.bulan);
        const pertemuan = parseInt(item.pertemuan);
        if (abs[bulan] && abs[bulan][pertemuan] !== undefined) {
            abs[bulan][pertemuan] = item.paraf_pelatih;
        }
    });

    for (let b = 1; b <= 12; b++) {
        const tr = document.createElement('tr');
        let html = `<td style="text-align:left; padding-left:10px;">${namaBulan[b]}</td>`;
        for (let p = 1; p <= 8; p++) {
            const paraf = abs[b][p];
            if (paraf) {
                const imgPath = `paraf/${encodeURIComponent(paraf)}.png`;
                html += `<td style="text-align:center;">
                    <img src="${imgPath}" alt="Paraf" style="max-height:30px; max-width:50px;" onerror="this.style.display='none'">
                </td>`;
            } else {
                html += `<td style="text-align:center;">-</td>`;
            }
        }
        tr.innerHTML = html;
        tbody.appendChild(tr);
    }
}

document.getElementById('btn-scan-ulang').addEventListener('click', () => {
    resetScanner();
});

document.getElementById('btn-update').addEventListener('click', () => {
    const nomor = document.getElementById('nomor-siswa').textContent.trim();
    const nomorSertifikat = document.getElementById('input-sertifikat').value.trim();
    const sabuk = document.getElementById('select-sabuk').value;

    if (!nomor) {
        alert('Scan dulu data siswa terlebih dahulu!');
        return;
    }

    fetch(window.location.href, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: new URLSearchParams({
            aksi: 'update_siswa',
            nomor_registrasi: nomor,
            nomor_sertifikat: nomorSertifikat,
            sabuk: sabuk
        })
    })
    .then(res => res.json())
    .then(data => {
        if (data.status === 'success') {
            alert('Data berhasil diperbarui!');
            // Optional: reload data biar update langsung ke UI
            loadSiswaData(nomor);
        } else {
            alert('Gagal memperbarui data: ' + (data.message || 'Unknown error'));
        }
    })
    .catch(() => alert('Kesalahan saat mengirim data ke server.'));
});

resetScanner();
</script>

</body>
</html>
