<?php
// notifikasi_helper.php
function kirimNotifikasiPelatih($pelatih, $isi) {
    global $pdo;

    // Simpan ke tabel notifikasi
    $stmt = $pdo->prepare("INSERT INTO notifikasi (pelatih, isi) VALUES (?, ?)");
    $stmt->execute([$pelatih, $isi]);

    // Kirim email
    $emails = [
        'Galih' => 'galih@example.com',
        'Wedu'  => 'momentumtkdclub@gmail.com',
        'Pridi' => 'pridi@example.com'
    ];
    if (!empty($emails[$pelatih])) {
        @mail($emails[$pelatih], 'Notifikasi Pembayaran', $isi);
    }

    // Kirim WhatsApp via Wablas
    $wa_nomor = [
        'Galih' => '62812xxxxxxx',
        'Wedu'  => '62813xxxxxxx',
        'Pridi' => '62814xxxxxxx'
    ];
    if (!empty($wa_nomor[$pelatih])) {
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://console.wablas.com/api/send-message',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                'Authorization: YOUR_WABLAS_API_KEY'
            ],
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query([
                'phone' => $wa_nomor[$pelatih],
                'message' => $isi
            ]),
        ]);
        curl_exec($curl);
        curl_close($curl);
    }
}
