<?php
session_start();
include '../db.php';

if (!isset($_SESSION['nomor_registrasi'])) {
    die('Unauthorized.');
}

$nomor_registrasi = $_SESSION['nomor_registrasi'];
$bulan = (int) ($_POST['bulan'] ?? 0);
$tahun = (int) ($_POST['tahun'] ?? 0);
$nama = $_SESSION['nama_lengkap'] ?? 'Siswa';

$amount = 50000; // Atur sesuai kebijakan lo
$invoiceRef = 'INV-' . $nomor_registrasi . '-' . time();

$data = [
    'method'         => 'QRIS',
    'merchant_ref'   => $invoiceRef,
    'amount'         => $amount,
    'customer_name'  => $nama,
    'order_items'    => [
        [
            'sku'      => 'iuran',
            'name'     => "Iuran Bulan $bulan/$tahun",
            'price'    => $amount,
            'quantity' => 1
        ]
    ],
    'callback_url' => 'https://domainmu.com/gateway/callback.php',
    'return_url'   => 'https://domainmu.com/siswa/dashboard.php',
    'expired_time' => time() + (60 * 60 * 12)
];

// === GANTI INI NANTI ===
$apiKey = 'TRIPAY_API_KEY_LO';
$url = "https://tripay.co.id/api/transaction/create";

$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => ['Authorization: Bearer ' . $apiKey],
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => http_build_query($data),
]);

$response = curl_exec($curl);
curl_close($curl);

$result = json_decode($response, true);

if ($result && $result['success']) {
    $payment = $result['data'];

    $stmt = $pdo->prepare("INSERT INTO iuran (nomor_registrasi, bulan, tahun, status, tipe_pembayaran, reference_code, payment_url) VALUES (?, ?, ?, 'pending', 'qris_api', ?, ?)");
    $stmt->execute([$nomor_registrasi, $bulan, $tahun, $invoiceRef, $payment['checkout_url']]);

    header("Location: " . $payment['checkout_url']);
    exit;
} else {
    echo "Gagal generate QRIS. Cek API KEY atau Merchant Code.";
}
