<?php
session_start();
if (!isset($_SESSION['data_idcard'])) {
    echo "Data tidak ditemukan. Silakan registrasi terlebih dahulu.";
    exit;
}

$data   = $_SESSION['data_idcard'];
$foto   = htmlspecialchars($data['foto']);
$nama   = htmlspecialchars($data['nama_lengkap']);
$dojang = htmlspecialchars($data['dojang_nama']);
$nomor  = htmlspecialchars($data['nomor_registrasi']);
$ttl    = htmlspecialchars($data['ttl']);
$qr     = htmlspecialchars($data['qr']);
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>ID Card - Momentum Taekwondo Club</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600&display=swap" rel="stylesheet" />
  <style>
    * { box-sizing: border-box; margin: 0; padding: 0; }
    body {
      font-family: 'Poppins', sans-serif;
      background: #f0f0f0;
      display: flex;
      flex-direction: column;
      align-items: center;
      padding: 100px 20px;
      min-height: 100vh;
    }

    .id-card {
      width: 53.98mm;
      height: 85.6mm;
      background: white;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.25);
      background-image: url('assets/images/BG_new.png');
      background-size: cover;
      background-position: center;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: flex-start;
      padding: 150px 20px 30px;
      position: relative;
      color: #000;
    }

    .photo-frame {
      width: 100px;
      height: 100px;
      border-radius: 50%;
      overflow: hidden;
      border: 4px solid white;
      background: #ccc;
      position: absolute;
      top: 53px;
      left: 50%;
      transform: translateX(-50%);
    }

    .photo-frame img {
      width: 100px;
      height: 100px;
      object-fit: cover;
      display: block;
    }

    .name {
      font-size: 11px;
      font-weight: 600;
      text-align: center;
      margin-bottom: 0px;
    }

    .dojang {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 6px;
      font-size: 8px;
      margin-top: 0px;
    }

    .dojang-icon {
      width: 16px;
      height: 16px;
    }

    .details {
      font-size: 8px;
      margin-top: 14px;
      width: 100%;
    }

    .info-row {
      display: flex;
      align-items: center;
      gap: 4px;
      margin-bottom: 2px;
    }

    .icon {
      width: 14px;
      height: 14px;
      object-fit: contain;
      flex-shrink: 0;
    }

    .qr-code {
      width: 70px;
      height: 70px;
      margin: 2px auto 0;
    }

    .qr-code img {
      width: 100%;
      height: 100%;
    }

    .btn {
      margin-top: 20px;
      padding: 10px 20px;
      font-size: 14px;
      background: #007BFF;
      color: white;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      z-index: 10;
      position: relative;
      display: inline-flex;
      align-items: center;
      gap: 6px;
    }

    .btn img {
      width: 16px;
      height: 16px;
      object-fit: contain;
    }
  </style>
</head>
<body>

  <div class="id-card" id="idcard">
    <div class="photo-frame">
      <img src="<?= $foto ?>" alt="Foto Siswa" />
    </div>
    <div class="name"><?= $nama ?></div>
    <div class="dojang">
      <img src="assets/images/dojang-icon.png" alt="Icon" class="dojang-icon" />
      <?= $dojang ?>
    </div>
    <div class="details">
      <div class="info-row">
        <img src="assets/images/id-card.png" alt="ID Icon" class="icon" />
        <span><?= $nomor ?></span>
      </div>
      <div class="info-row">
        <img src="assets/images/calendar.png" alt="Calendar Icon" class="icon" />
        <span><?= $ttl ?></span>
      </div>
    </div>
    <div class="qr-code">
      <img src="<?= $qr ?>" alt="QR Code" />
    </div>
  </div>

  <div style="margin-top: 80px;">
    <button class="btn" onclick="printIDCardOnly()">
      <img src="assets/images/printer.png" alt="Print Icon" />
      Cetak Kartu
    </button>
  </div>

  <script>
  function printIDCardOnly() {
    const card = document.getElementById("idcard");
    const win = window.open('', 'PrintWindow', 'width=400,height=600');

    const style = `
      <style>
        * { box-sizing: border-box; margin: 0; padding: 0; }
        body {
          font-family: 'Poppins', sans-serif;
          margin: 0;
          padding: 0;
        }
        .id-card {
          width: 53.98mm;
          height: 85.6mm;
          background: white;
          border-radius: 12px;
          background-image: url('assets/images/BG_new.png');
          background-size: cover;
          background-position: center;
          display: flex;
          flex-direction: column;
          align-items: center;
          justify-content: flex-start;
          padding: 150px 20px 30px;
          color: #000;
          position: relative;
        }
        .photo-frame {
          width: 100px;
          height: 100px;
          border-radius: 50%;
          overflow: hidden;
          border: 4px solid white;
          background: #ccc;
          position: absolute;
          top: 53px;
          left: 50%;
          transform: translateX(-50%);
        }
        .photo-frame img {
          width: 100%;
          height: 100%;
          object-fit: cover;
        }
        .name {
          font-size: 11px;
          font-weight: 600;
          text-align: center;
        }
        .dojang {
          display: flex;
          align-items: center;
          justify-content: center;
          gap: 6px;
          font-size: 8px;
        }
        .dojang-icon {
          width: 16px;
          height: 16px;
        }
        .details {
          font-size: 8px;
          margin-top: 14px;
          width: 100%;
        }
        .info-row {
          display: flex;
          align-items: center;
          gap: 4px;
          margin-bottom: 2px;
        }
        .icon {
          width: 14px;
          height: 14px;
          object-fit: contain;
          flex-shrink: 0;
        }
        .qr-code {
          width: 70px;
          height: 70px;
          margin: 0px auto 0;
        }
        .qr-code img {
          width: 100%;
          height: 100%;
        }

        @page {
          size: 53.98mm 85.6mm;
          margin: 0;
        }

        @media print {
          body {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
          }
        }
      </style>
    `;

    win.document.write(`
      <html>
        <head>
          <title>Print ID Card</title>
          <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600&display=swap" rel="stylesheet" />
          ${style}
        </head>
        <body onload="window.print(); window.close();">
          ${card.outerHTML}
        </body>
      </html>
    `);

    win.document.close();
  }
  </script>

</body>
</html>
