<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'pelatih') {
    header('Location: ../login.php');
    exit;
}
include '../db.php';

// Ambil daftar dojang untuk dropdown
$dojangs = $pdo->query("SELECT kode_dojang, nama_dojang FROM dojang ORDER BY nama_dojang ASC")->fetchAll(PDO::FETCH_ASSOC);

// Ambil filter dari GET (default semua)
$bulan = $_GET['bulan'] ?? date('m');
$tahun = $_GET['tahun'] ?? date('Y');
$filterDojang = $_GET['kode_dojang'] ?? '';

// Normalize phone number helper
function normalizePhoneNumber($number) {
    $number = preg_replace('/[^0-9]/', '', $number);
    if (substr($number, 0, 1) === '0') {
        $number = '62' . substr($number, 1);
    }
    return $number;
}

// Kirim WA message
function sendWaMessage($phone, $message) {
    $url     = 'https://app.wapanels.com/api/create-message';
    $payload = [
        'appkey'   => 'eace99a4-2b6f-4084-bea2-a8755d5cce06',
        'authkey'  => 'MDtxasW64gTygBReQRiFZoBtb1c9opHntQ17FT9iW6QQNUuWzN',
        'to'       => $phone,
        'message'  => $message,
        'sandbox'  => false
    ];

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER     => ['Content-Type: application/json'],
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_SLASHES)
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlErr  = curl_error($ch);
    curl_close($ch);

    error_log("WA-Panels [$httpCode]: curl_err={$curlErr} resp={$response}");
    $res = json_decode($response, true);
    if (isset($res['message_status']) && strtolower($res['message_status']) === 'success') {
        return ['success' => true];
    }
    return ['success' => false, 'payload' => $res];
}

// Build where clause dan params sesuai filter dojang
$whereDojang = '';
$params = ['bulan' => $bulan, 'tahun' => $tahun];
if ($filterDojang && in_array($filterDojang, array_column($dojangs, 'kode_dojang'))) {
    $whereDojang = ' AND s.kode_dojang = :kode_dojang ';
    $params['kode_dojang'] = $filterDojang;
}

// Ambil data siswa + iuran + dojang dengan filter
$sql = "
    SELECT
        s.nomor_registrasi,
        s.nama_lengkap,
        s.no_hp,
        s.kode_dojang,
        d.nama_dojang,
        COALESCE(LOWER(i.status), 'belum bayar') AS status,
        COALESCE(i.reminder_sent, 0) AS reminder_sent
    FROM siswa s
    LEFT JOIN dojang d ON s.kode_dojang = d.kode_dojang
    LEFT JOIN (
        SELECT i1.*
        FROM iuran i1
        INNER JOIN (
            SELECT nomor_registrasi, MAX(waktu_bayar) AS max_waktu
            FROM iuran
            WHERE bulan = :bulan AND tahun = :tahun
            GROUP BY nomor_registrasi
        ) i2 ON i1.nomor_registrasi = i2.nomor_registrasi AND i1.waktu_bayar = i2.max_waktu
        WHERE i1.bulan = :bulan AND i1.tahun = :tahun
    ) i ON s.nomor_registrasi = i.nomor_registrasi
    WHERE 1=1
    $whereDojang
    ORDER BY s.nama_lengkap ASC
";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$siswaList = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Hitung statistik sesuai filter
$jmlLunas = $jmlPending = $jmlBelumBayar = 0;
foreach ($siswaList as $sw) {
    switch ($sw['status']) {
        case 'lunas': $jmlLunas++; break;
        case 'pending': $jmlPending++; break;
        default: $jmlBelumBayar++; break;
    }
}
$totalSiswa = count($siswaList);

// Handle AJAX POST kirim WA
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    
    // Pakai filter dojang juga di query POST
    $postParams = ['bulan' => $bulan, 'tahun' => $tahun];
    if ($filterDojang && in_array($filterDojang, array_column($dojangs, 'kode_dojang'))) {
        $postParams['kode_dojang'] = $filterDojang;
    }
    
    if ($_POST['action'] === 'send_single') {
        $nr = $_POST['nomor_registrasi'] ?? '';
        if (!$nr) {
            echo json_encode(['success' => false, 'message' => 'Nomor registrasi tidak ditemukan']);
            exit;
        }

        $sql2 = "
            SELECT s.nama_lengkap, s.no_hp, s.kode_dojang, COALESCE(LOWER(i.status), 'belum bayar') AS status, COALESCE(i.reminder_sent, 0) AS reminder_sent
            FROM siswa s
            LEFT JOIN iuran i ON s.nomor_registrasi = i.nomor_registrasi AND i.bulan = :bulan AND i.tahun = :tahun
            WHERE s.nomor_registrasi = :nr
        ";
        if ($filterDojang) {
            $sql2 .= " AND s.kode_dojang = :kode_dojang ";
            $postParams['kode_dojang'] = $filterDojang;
        }
        $stmt2 = $pdo->prepare($sql2);
        $postParams['nr'] = $nr;
        $stmt2->execute($postParams);
        $s = $stmt2->fetch(PDO::FETCH_ASSOC);

        if (!$s) {
            echo json_encode(['success' => false, 'message' => 'Data siswa tidak ditemukan atau tidak sesuai filter dojang']);
            exit;
        }
        if (!in_array($s['status'], ['belum bayar', 'pending'])) {
            echo json_encode(['success' => false, 'message' => 'Status siswa sudah lunas, tidak perlu reminder']);
            exit;
        }

        // Limit reminder max 3x (optional)
        if ($s['reminder_sent'] >= 3) {
            echo json_encode(['success' => false, 'message' => 'Reminder sudah dikirim maksimal 3 kali']);
            exit;
        }

        $phone = normalizePhoneNumber($s['no_hp']);
        $message = "Halo *{$s['nama_lengkap']}*,\n\nKami mengingatkan bahwa iuran bulan *{$bulan}* tahun *{$tahun}* belum diterima.\nMohon segera melakukan pembayaran agar tetap aktif.\n\nTerima kasih,\nTaekwondo Momentum";

        $res = sendWaMessage($phone, $message);

        if ($res && isset($res['success']) && $res['success'] === true) {
            $update = $pdo->prepare("
                UPDATE iuran
                SET reminder_sent = reminder_sent + 1
                WHERE nomor_registrasi = :nr AND bulan = :bulan AND tahun = :tahun
            ");
            $update->execute(['nr' => $nr, 'bulan' => $bulan, 'tahun' => $tahun]);
            echo json_encode(['success' => true, 'message' => "Reminder berhasil dikirim ke {$s['nama_lengkap']}"]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Gagal mengirim reminder, coba lagi nanti']);
        }
        exit;
    }

    if ($_POST['action'] === 'send_all') {
        $sql3 = "
            SELECT s.nomor_registrasi, s.nama_lengkap, s.no_hp, s.kode_dojang, i.status, i.reminder_sent
            FROM iuran i
            JOIN siswa s ON i.nomor_registrasi = s.nomor_registrasi
            WHERE i.bulan = :bulan AND i.tahun = :tahun AND i.status IN ('belum bayar','pending') AND i.reminder_sent < 3
        ";
        if ($filterDojang) {
            $sql3 .= " AND s.kode_dojang = :kode_dojang ";
            $postParams['kode_dojang'] = $filterDojang;
        }
        $stmt3 = $pdo->prepare($sql3);
        $stmt3->execute($postParams);
        $list = $stmt3->fetchAll(PDO::FETCH_ASSOC);

        $successCount = 0;
        $failList = [];

        foreach ($list as $s) {
            $phone = normalizePhoneNumber($s['no_hp']);
            $message = "Halo *{$s['nama_lengkap']}*,\n\nKami mengingatkan bahwa iuran bulan *{$bulan}* tahun *{$tahun}* belum diterima.\nMohon segera melakukan pembayaran agar tetap aktif.\n\nTerima kasih,\nTaekwondo Momentum";

            $res = sendWaMessage($phone, $message);

            if ($res && isset($res['success']) && $res['success'] === true) {
                $update = $pdo->prepare("
                    UPDATE iuran
                    SET reminder_sent = reminder_sent + 1
                    WHERE nomor_registrasi = :nr AND bulan = :bulan AND tahun = :tahun
                ");
                $update->execute(['nr' => $s['nomor_registrasi'], 'bulan' => $bulan, 'tahun' => $tahun]);
                $successCount++;
            } else {
                $failList[] = $s['nama_lengkap'];
            }
        }

        $msg = "Reminder terkirim ke {$successCount} siswa.";
        if ($failList) {
            $msg .= " Gagal kirim ke: " . implode(', ', $failList);
        }
        echo json_encode(['success' => true, 'message' => $msg]);
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<title>Dashboard Pelatih - Reminder Iuran</title>
<style>
body { font-family: Arial, sans-serif; background: #f7f9fc; padding: 20px; }
h1 { margin-bottom: 20px; }
.filter {
    margin-bottom: 30px;
    display: flex;
    gap: 15px;
    align-items: center;
}
select {
    padding: 8px 12px;
    font-size: 16px;
    border-radius: 6px;
    border: 1px solid #ccc;
}
.status-summary {
    display: flex;
    gap: 20px;
    margin-bottom: 30px;
}
.status-box {
    background: white;
    flex: 1;
    padding: 20px 30px;
    border-radius: 10px;
    box-shadow: 0 3px 8px rgb(0 0 0 / 0.1);
    text-align: center;
    cursor: pointer;
    user-select: none;
    transition: background-color 0.3s ease;
}
.status-box:hover {
    background-color: #e2e6ea;
}
.status-box.active {
    background-color: #007bff;
    color: white;
}
.status-box h2 {
    margin: 0;
    font-size: 3rem;
}
.status-box p {
    margin: 10px 0 0;
    font-weight: 600;
}
table {
    width: 100%;
    border-collapse: collapse;
    background: white;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 3px 8px rgb(0 0 0 / 0.1);
    margin-bottom: 30px;
}
th, td {
    padding: 12px 15px;
    border-bottom: 1px solid #ddd;
    text-align: left;
}
th {
    background: #007bff;
    color: white;
    user-select: none;
}
tr:last-child td {
    border-bottom: none;
}
/* Status color classes */
.status-belum-bayar {
  color: #721c24;
  background-color: #f8d7da;
  font-weight: 700;
  padding: 4px 8px;
  border-radius: 6px;
  display: inline-block;
}
.status-pending {
  color: #856404;
  background-color: #fff3cd;
  font-weight: 700;
  padding: 4px 8px;
  border-radius: 6px;
  display: inline-block;
}
.status-lunas {
  color: #155724;
  background-color: #d4edda;
  font-weight: 700;
  padding: 4px 8px;
  border-radius: 6px;
  display: inline-block;
}

button, .btn-remind {
    padding: 6px 10px;
    background-color: #007bff;
    color: white;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-weight: 600;
    transition: background-color 0.3s ease;
}
button:hover, .btn-remind:hover {
    background-color: #0056b3;
}
button:disabled, .btn-remind:disabled {
    background-color: #aaa;
    cursor: not-allowed;
}
.notif {
    margin-top: 15px;
    padding: 12px 15px;
    border-radius: 6px;
    background: #d4edda;
    color: #155724;
    display: none;
}
</style>
</head>
<body>

<h1>Dashboard Pelatih - Reminder Iuran</h1>

<form class="filter" method="GET" action="">
    <label for="bulan">Bulan:</label>
    <select id="bulan" name="bulan" onchange="this.form.submit()">
        <?php for ($m = 1; $m <= 12; $m++):
            $selected = ($m == (int)$bulan) ? 'selected' : '';
            $monthName = date('F', mktime(0,0,0,$m,1));
        ?>
            <option value="<?= $m ?>" <?= $selected ?>><?= $monthName ?></option>
        <?php endfor; ?>
    </select>

    <label for="tahun">Tahun:</label>
    <select id="tahun" name="tahun" onchange="this.form.submit()">
        <?php
        $yearNow = date('Y');
        for ($y = $yearNow - 5; $y <= $yearNow + 1; $y++):
            $selected = ($y == (int)$tahun) ? 'selected' : '';
        ?>
            <option value="<?= $y ?>" <?= $selected ?>><?= $y ?></option>
        <?php endfor; ?>
    </select>

    <label for="kode_dojang">Dojang:</label>
    <select id="kode_dojang" name="kode_dojang" onchange="this.form.submit()">
        <option value="">-- Semua Dojang --</option>
        <?php foreach ($dojangs as $d): ?>
            <option value="<?= htmlspecialchars($d['kode_dojang']) ?>" <?= ($filterDojang === $d['kode_dojang']) ? 'selected' : '' ?>>
                <?= htmlspecialchars($d['nama_dojang']) ?>
            </option>
        <?php endforeach; ?>
    </select>
</form>

<div class="status-summary">
    <div class="status-box active" data-status="all">
        <h2><?= $totalSiswa ?></h2>
        <p>Total Siswa Aktif</p>
    </div>
    <div class="status-box" data-status="pending" style="background:#fff3cd;color:#856404;">
        <h2><?= $jmlPending ?></h2>
        <p>Siswa Pending Pembayaran</p>
    </div>
    <div class="status-box" data-status="belum bayar" style="background:#f8d7da;color:#721c24;">
        <h2><?= $jmlBelumBayar ?></h2>
        <p>Siswa Belum Bayar</p>
    </div>
    <div class="status-box" data-status="lunas" style="background:#d4edda;color:#155724;">
        <h2><?= $jmlLunas ?></h2>
        <p>Siswa Lunas Bulan Ini</p>
    </div>
</div>

<button id="btn-remind-all" style="margin-bottom: 20px;">Kirim Reminder WA ke Semua Pending & Belum Bayar</button>
<div class="notif" id="notif"></div>

<table id="siswa-table">
    <thead>
        <tr>
            <th>Nomor Registrasi</th>
            <th>Nama Lengkap</th>
            <th>Dojang</th>
            <th>No HP</th>
            <th>Status Pembayaran</th>
            <th>Status Reminder</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($siswaList as $siswa): 
            $statusClass = '';
            switch($siswa['status']){
                case 'belum bayar': $statusClass = 'status-belum-bayar'; break;
                case 'pending': $statusClass = 'status-pending'; break;
                case 'lunas': $statusClass = 'status-lunas'; break;
                default: $statusClass = '';
            }
        ?>
        <tr data-status="<?= htmlspecialchars($siswa['status']) ?>">
            <td><?= htmlspecialchars($siswa['nomor_registrasi']) ?></td>
            <td><?= htmlspecialchars($siswa['nama_lengkap']) ?></td>
            <td><?= htmlspecialchars($siswa['nama_dojang'] ?? $siswa['kode_dojang']) ?></td>
            <td><?= htmlspecialchars($siswa['no_hp']) ?></td>
            <td><span class="<?= $statusClass ?>"><?= htmlspecialchars(ucfirst($siswa['status'])) ?></span></td>
            <td>
                <?= $siswa['reminder_sent'] > 0 ? "Sudah dikirim {$siswa['reminder_sent']}x" : 'Belum dikirim' ?>
            </td>
            <td>
                <?php if ($siswa['reminder_sent'] < 3 && in_array($siswa['status'], ['belum bayar', 'pending'])): ?>
                <button class="btn-remind" data-nomor="<?= htmlspecialchars($siswa['nomor_registrasi']) ?>">Kirim Reminder</button>
                <?php else: ?>
                <button disabled>
                    <?php 
                    if ($siswa['reminder_sent'] >= 3) {
                        echo 'Maksimal reminder tercapai';
                    } else {
                        echo 'Sudah Kirim';
                    }
                    ?>
                </button>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const notif = document.getElementById('notif');

    function showNotif(msg) {
        notif.style.display = 'block';
        notif.textContent = msg;
        setTimeout(() => { notif.style.display = 'none'; }, 5000);
    }

    // Status filter client-side toggle
    const statusBoxes = document.querySelectorAll('.status-box');
    const siswaRows = document.querySelectorAll('#siswa-table tbody tr');

    statusBoxes.forEach(box => {
        box.addEventListener('click', () => {
            statusBoxes.forEach(b => b.classList.remove('active'));
            box.classList.add('active');

            const status = box.getAttribute('data-status');
            siswaRows.forEach(row => {
                const rowStatus = row.getAttribute('data-status');
                if (status === 'all' || rowStatus === status) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        });
    });

    // Kirim reminder per siswa
    document.querySelectorAll('.btn-remind').forEach(btn => {
        btn.addEventListener('click', () => {
            const nomor = btn.getAttribute('data-nomor');
            btn.disabled = true;
            showNotif('Mengirim reminder ke ' + nomor + '...');

            fetch('', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: new URLSearchParams({
                    action: 'send_single',
                    nomor_registrasi: nomor
                })
            })
            .then(res => res.json())
            .then(data => {
                showNotif(data.message);
                if (data.success) {
                    btn.textContent = 'Sudah Kirim';
                    btn.disabled = true;
                    // Optional: reload page or update UI dynamically
                    setTimeout(() => location.reload(), 1000);
                } else {
                    btn.disabled = false;
                }
            })
            .catch(() => {
                showNotif('Gagal mengirim reminder.');
                btn.disabled = false;
            });
        });
    });

    // Kirim reminder ke semua siswa belum bayar & pending sesuai filter dojang
    const btnAll = document.getElementById('btn-remind-all');
    btnAll.addEventListener('click', () => {
        btnAll.disabled = true;
        showNotif('Mengirim reminder ke semua siswa belum bayar dan pending...');

        fetch('', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams({
                action: 'send_all'
            })
        })
        .then(res => res.json())
        .then(data => {
            showNotif(data.message);
            btnAll.disabled = false;
            if (data.success) {
                window.location.reload();
            }
        })
        .catch(() => {
            showNotif('Gagal mengirim reminder.');
            btnAll.disabled = false;
        });
    });
});
</script>

</body>
</html>
