<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

$nama_siswa = htmlspecialchars($_SESSION['nama_lengkap'] ?? $_SESSION['username']);


?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <title>Dashboard Siswa</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f9f9f9;
            margin: 0;
            padding: 0 20px;
        }
        header {
            background-color: #007BFF;
            color: white;
            padding: 15px 20px;
            text-align: center;
            font-size: 24px;
            font-weight: 700;
        }
        nav {
            margin: 20px auto;
            max-width: 400px;
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        nav li {
            margin-bottom: 15px;
        }
        nav a {
            text-decoration: none;
            color: #007BFF;
            font-weight: 600;
            font-size: 18px;
            display: block;
            padding: 12px 20px;
            border: 2px solid #007BFF;
            border-radius: 8px;
            transition: background-color 0.3s ease, color 0.3s ease;
        }
        nav a:hover {
            background-color: #007BFF;
            color: white;
        }
        .logout-link {
            text-align: center;
            display: block;
            margin-top: 30px;
            font-weight: 700;
            color: #d9534f;
            text-decoration: none;
            font-size: 18px;
            transition: color 0.3s ease;
        }
        .logout-link:hover {
            color: #a93226;
        }
    </style>
</head>
<body>

<header>
    Selamat datang, <?= $nama_siswa ?>
</header>

<nav>
    <ul>
        <li><a href="edit_data_siswa.php">📝 Update Data Anda</a></li>        
<li><a href="report_absensi_siswa.php">📅 Lihat Absensi Anda</a></li>
<li><a href="lihat_iuran.php">💰 Status Iuran Anda</a></li>
<li><a href="formulir_siswa.php">📄 Formulir UKT</a></li>
<li><a href="form_iuran_perdojang.php">💳 Pembayaran Iuran</a></li>
<li><a href="idcard.php">🆔 Cetak / Edit ID Card Anda</a></li>
<li><a href="prestasi.php">🏆 Prestasi Anda</a></li> 
<li><a href="dokumen.php">📂 Dokumen Anda</a></li> 
<li><a href="ganti_password.php">🔒 Ganti Password</a></li> <!-- Ganti password -->
    </ul>
    <a href="../logout.php" class="logout-link">🚪 Logout</a>
</nav>

</body>
</html>
