<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include '../db.php'; // Koneksi $pdo

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

$nomor_registrasi = $_SESSION['nomor_registrasi'];

// Ambil data siswa
$stmt = $pdo->prepare("SELECT * FROM siswa WHERE nomor_registrasi = :nomor_registrasi");
$stmt->execute(['nomor_registrasi' => $nomor_registrasi]);
$siswa = $stmt->fetch(PDO::FETCH_ASSOC);

// Ambil dokumen yang sudah diupload
$folder_dokumen = "uploads/dokumen/$nomor_registrasi";
$files = is_dir($folder_dokumen) ? array_diff(scandir($folder_dokumen), ['.', '..']) : [];

$sabuk_list = [
    "Kuning", "Kuning Strip Hijau", "Hijau", "Hijau Strip Biru",
    "Biru", "Biru Strip Merah", "Merah", "Merah Strip 1", "Merah Strip 2"
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Dokumen Siswa</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<div style="margin-bottom: 20px;">
  <a href="/siswa/dashboard.php" 
     style="display: inline-block; padding: 10px 20px; background: #007BFF; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; transition: background-color 0.3s ease;">
    &larr; Kembali ke Dashboard
  </a>
</div>
<body class="bg-gray-100 p-6">
<div class="max-w-4xl mx-auto space-y-6">

    <!-- Data Siswa -->
    <div class="bg-white p-4 rounded shadow">
        <h2 class="text-xl font-bold mb-4">Data Siswa</h2>
        <div class="flex items-start space-x-4">
            <?php if (!empty($siswa['foto'])): ?>
                <img src="../<?= htmlspecialchars($siswa['foto']) ?>" alt="Foto" class="w-32 h-32 rounded object-cover border">
            <?php else: ?>
                <div class="w-32 h-32 rounded bg-gray-200 flex items-center justify-center text-gray-500">No Foto</div>
            <?php endif; ?>
            <div>
                <p><strong>Nama:</strong> <?= htmlspecialchars($siswa['nama_lengkap']) ?></p>
                <p><strong>Dojang:</strong> <?= htmlspecialchars($siswa['kode_dojang']) ?></p>
                <p><strong>Alamat:</strong> <?= htmlspecialchars($siswa['alamat_lengkap']) ?></p>
                <p><strong>TTL:</strong> <?= htmlspecialchars($siswa['tempat_tgl_lahir']) ?></p>
                <p><strong>Sabuk:</strong> <?= htmlspecialchars($siswa['sabuk']) ?></p>
                <?php if ($siswa['sabuk']): ?>
                    <img src="/sabuk/<?= strtolower(str_replace(' ', '_', $siswa['sabuk'])) ?>.png" alt="Gambar Sabuk" class="mt-2 h-6">
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Form Upload -->
    <div class="bg-white p-6 rounded shadow">
        <h3 class="text-lg font-semibold mb-4">Upload Dokumen</h3>
        <form id="uploadForm" enctype="multipart/form-data">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block mb-1 font-medium">Jenis Dokumen</label>
                    <select name="jenis_dokumen" class="w-full p-2 border rounded" required>
                        <option value="akte_lahir">Akte Lahir</option>
                         <option value="sertifikat_kejuaraan">Sertifikat Kejuaraan</option>
                        <option value="sertifikat_sabuk">Sertifikat Sabuk</option>
                    </select>
                </div>
                <div>
                    <label class="block mb-1 font-medium">Sabuk (Jika Sertifikat)</label>
                    <select name="sabuk" class="w-full p-2 border rounded">
                        <option value="">- Pilih Sabuk -</option>
                        <?php foreach ($sabuk_list as $sabuk): ?>
                            <option value="<?= htmlspecialchars($sabuk) ?>"><?= htmlspecialchars($sabuk) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="md:col-span-2">
                    <label class="block mb-1 font-medium">File Dokumen</label>
                    <input type="file" name="file_dokumen" required class="w-full p-2 border rounded bg-white" accept=".jpg,.jpeg,.png,.pdf">
                </div>
            </div>
            <div class="mt-4">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Upload</button>
            </div>
        </form>
        <div id="uploadStatus" class="mt-2 text-sm text-green-600"></div>
    </div>

    <!-- Dokumen Tersimpan -->
    <div class="bg-white p-6 rounded shadow">
        <h3 class="text-lg font-semibold mb-4">Dokumen Tersimpan</h3>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4">
            <?php if (count($files) > 0): ?>
                <?php foreach ($files as $file): 
                    $filePath = "$folder_dokumen/$file";
                    $isImage = preg_match('/\.(jpg|jpeg|png)$/i', $file);
                    $isPdf = preg_match('/\.pdf$/i', $file);
                ?>
                <div class="bg-gray-50 border rounded-lg p-3 shadow hover:shadow-md transition">
                    <?php if ($isImage): ?>
                        <a href="<?= $filePath ?>" target="_blank">
                            <img src="<?= $filePath ?>" alt="<?= htmlspecialchars($file) ?>" class="h-40 w-full object-cover rounded mb-2">
                        </a>
                    <?php elseif ($isPdf): ?>
                        <a href="<?= $filePath ?>" target="_blank">
                            <div class="h-40 w-full flex items-center justify-center border rounded bg-white mb-2">
                                <span class="text-4xl">📄</span>
                            </div>
                        </a>
                    <?php else: ?>
                        <div class="h-40 flex items-center justify-center bg-gray-100 border rounded mb-2 text-gray-600">
                            <span>File tidak dikenali</span>
                        </div>
                    <?php endif; ?>
                    <p class="text-sm font-medium truncate"><?= htmlspecialchars($file) ?></p>
                    <a href="<?= $filePath ?>" download class="text-blue-600 text-sm hover:underline">Download</a>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p class="text-gray-500">Belum ada dokumen diunggah.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- JS Upload -->
<script>
document.getElementById('uploadForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    const formData = new FormData(this);

    const res = await fetch('upload_dokumen.php', {
        method: 'POST',
        body: formData
    });

    const result = await res.text();
    document.getElementById('uploadStatus').innerText = result;
    setTimeout(() => location.reload(), 2000);
});
</script>
</body>
</html>
