<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include '../db.php';

// Cek session siswa
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

$nomor = $_SESSION['nomor_registrasi'] ?? '';
if (!$nomor) {
    die('Nomor registrasi tidak ditemukan di session.');
}

// Handle update data via POST
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['aksi'])) {
    // Update data umum (nomor_sertifikat, sabuk)
    if ($_POST['aksi'] === 'update_siswa') {
        $nomor_post = $_POST['nomor_registrasi'] ?? '';
        $nomor_sertifikat = $_POST['nomor_sertifikat'] ?? null;
        $sabuk = $_POST['sabuk'] ?? null;

        if (!$nomor_post) {
            echo json_encode(['status' => 'error', 'message' => 'Nomor registrasi diperlukan']);
            exit;
        }

        $fieldsToUpdate = [];
        $params = [];

        if ($nomor_sertifikat !== null) {
            $fieldsToUpdate[] = "nomor_sertifikat = ?";
            $params[] = $nomor_sertifikat;
        }
        if ($sabuk !== null) {
            $fieldsToUpdate[] = "sabuk = ?";
            $params[] = $sabuk;
        }

        if (empty($fieldsToUpdate)) {
            echo json_encode(['status' => 'error', 'message' => 'Tidak ada data untuk diupdate']);
            exit;
        }

        $params[] = $nomor_post;

        $sql = "UPDATE siswa SET " . implode(', ', $fieldsToUpdate) . " WHERE nomor_registrasi = ?";
        $stmt = $pdo->prepare($sql);

        if ($stmt->execute($params)) {
            echo json_encode(['status' => 'success', 'message' => 'Data berhasil diperbarui']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Gagal memperbarui data']);
        }
        exit;
    }

    // Update Alamat, No HP, dan Tempat Tgl Lahir
    if ($_POST['aksi'] === 'update_data_siswa') {
        $nomor_post = $_POST['nomor_registrasi'] ?? '';
        $alamat = $_POST['alamat'] ?? null;
        $no_hp = $_POST['no_hp'] ?? null;
        $tempat_tgl_lahir = $_POST['tempat_tgl_lahir'] ?? null;

        if (!$nomor_post) {
            echo json_encode(['status' => 'error', 'message' => 'Nomor registrasi diperlukan']);
            exit;
        }

        $fieldsToUpdate = [];
        $params = [];

        if ($alamat !== null) {
            $fieldsToUpdate[] = "alamat_lengkap = ?";
            $params[] = $alamat;
        }
        if ($no_hp !== null) {
            $fieldsToUpdate[] = "no_hp = ?";
            $params[] = $no_hp;
        }
        if ($tempat_tgl_lahir !== null) {
            $fieldsToUpdate[] = "tempat_tgl_lahir = ?";
            $params[] = $tempat_tgl_lahir;
        }

        if (empty($fieldsToUpdate)) {
            echo json_encode(['status' => 'error', 'message' => 'Tidak ada data untuk diupdate']);
            exit;
        }

        $params[] = $nomor_post;

        $sql = "UPDATE siswa SET " . implode(', ', $fieldsToUpdate) . " WHERE nomor_registrasi = ?";
        $stmt = $pdo->prepare($sql);

        if ($stmt->execute($params)) {
            echo json_encode(['status' => 'success', 'message' => 'Data berhasil diperbarui']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Gagal memperbarui data']);
        }
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<title>MOMENTUM TAEKWONDO CLUB - Data Siswa</title>
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
<style>
body {
    font-family: 'Roboto', sans-serif;
    background: #f4f6f8;
    margin: 0 auto;
    padding: 20px;
    max-width: 800px;
    color: #333;
}
h1 {
    text-align: center;
    background: linear-gradient(to right, #007BFF, #00C6FF);
    color: white;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    margin-bottom: 30px;
}
#info-siswa {
    background: #fff;
    border-radius: 10px;
    padding: 25px;
    margin-top: 30px;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
}
#foto-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
    margin-bottom: 20px;
}
#img-siswa {
    width: 120px;
    height: 140px;
    object-fit: cover;
    border: 2px solid #007BFF;
    background: #f0f0f0;
    border-radius: 8px;
    transition: transform 0.3s ease;
}
#img-siswa:hover {
    transform: scale(1.05);
}
#img-sabuk {
    max-width: 120px;
    height: auto;
    border: 2px solid #007BFF;
    border-radius: 6px;
}
label {
    display: block;
    margin-top: 15px;
    font-weight: 700;
    color: #007BFF;
}
select,
input[type="text"],
input[type="file"],
textarea,
input[type="date"] {
    width: 100%;
    padding: 10px;
    margin-top: 5px;
    box-sizing: border-box;
    border-radius: 6px;
    border: 1px solid #ccc;
    font-size: 15px;
    transition: border 0.3s;
}
select:focus,
input[type="text"]:focus,
input[type="file"]:focus,
textarea:focus,
input[type="date"]:focus {
    border-color: #007BFF;
    outline: none;
}
button {
    background: #007BFF;
    color: white;
    border: none;
    padding: 6px 12px;
    border-radius: 6px;
    font-size: 12px;
    margin-left: 10px;
    cursor: pointer;
    transition: background 0.3s ease;
}
button:hover,
button:focus {
    background: #0056b3;
    outline: none;
}
table {
    border-collapse: collapse;
    width: 100%;
    margin-top: 20px;
    font-size: 14px;
    background: #fff;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 3px 12px rgba(0, 0, 0, 0.05);
}
th, td {
    border: 1px solid #eee;
    padding: 10px;
    text-align: center;
    vertical-align: middle;
}
th {
    background: #007BFF;
    color: white;
    font-weight: 600;
}
#tabel-absensi img {
    max-height: 30px;
    max-width: 50px;
}
#list-prestasi ul {
    list-style-type: disc;
    padding-left: 20px;
}
#list-prestasi li {
    margin-bottom: 8px;
    text-align: left;
}
.edit-container {
    display: none;
    margin-top: 10px;
}
.edit-container input {
    margin-top: 5px;
}
</style>
</head>
<body>
<div style="margin-bottom: 20px;">
  <a href="/siswa/dashboard.php" 
     style="display: inline-block; padding: 10px 20px; background: #007BFF; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; transition: background-color 0.3s ease;">
    &larr; Kembali ke Dashboard
  </a>
</div>
    
<h1>MOMENTUM TAEKWONDO CLUB</h1>

<div id="info-siswa" tabindex="0" aria-live="polite" aria-atomic="true">
    <div id="foto-container">
        <img src="" alt="Foto Siswa" id="img-siswa">
        <img src="" alt="Gambar Sabuk" id="img-sabuk">
    </div>

    <h2 id="nama-siswa"></h2>
    <p><strong>Nomor Registrasi:</strong> <span id="nomor-siswa"></span></p>
    <p><strong>Dojang:</strong> <span id="dojang-siswa"></span></p>
    
    <div>
        <p><strong>Alamat:</strong> <span id="alamat-siswa"></span>
        <button id="edit-alamat">Edit</button></p>
        <div class="edit-container" id="edit-alamat-container">
            <label for="input-alamat">Update Alamat</label>
            <input type="text" id="input-alamat" placeholder="Masukkan alamat siswa">
            <button id="update-alamat">Update</button>
        </div>
    </div>

    <div>
        <p><strong>No HP:</strong> <span id="nohp-siswa"></span>
        <button id="edit-nohp">Edit</button></p>
        <div class="edit-container" id="edit-nohp-container">
            <label for="input-nohp">Update No HP</label>
            <input type="text" id="input-nohp" placeholder="Masukkan no HP siswa">
            <button id="update-nohp">Update</button>
        </div>
    </div>

    <div>
        <p><strong>Tanggal Lahir:</strong> <span id="ttl-siswa"></span>
        <button id="edit-ttl">Edit</button></p>
        <div class="edit-container" id="edit-ttl-container">
            <label for="input-ttl">Update Tempat, Tanggal Lahir</label>
            <input type="text" id="input-ttl" placeholder="Masukkan tempat dan tanggal lahir siswa">
            <button id="update-ttl">Update</button>
        </div>
    </div>

        <div>
        <p><strong>Nomor Sertifikat:</strong> <span id="nomor-sertifikat-siswa"></span>
        <button id="edit-sertifikat">Edit</button></p>
        <div class="edit-container" id="edit-sertifikat-container">
            <label for="input-sertifikat">Update Nomor Sertifikat</label>
            <input type="text" id="input-sertifikat" placeholder="Masukkan nomor sertifikat">
            <button id="update-sertifikat">Update Nomor Sertifikat</button>
        </div>
    </div>

    <div>
        <label for="select-sabuk">Update Sabuk</label>
        <select id="select-sabuk" aria-label="Update sabuk">
            <option value="Putih">Putih</option>
            <option value="Kuning">Kuning</option>
            <option value="Kuning Strip Hijau">Kuning Strip Hijau</option>
            <option value="Hijau">Hijau</option>
            <option value="Hijau Strip Biru">Hijau Strip Biru</option>
            <option value="Biru">Biru</option>
            <option value="Biru Strip Merah">Biru Strip Merah</option>
            <option value="Merah">Merah</option>
            <option value="Merah Strip 1">Merah Strip 1</option>
            <option value="Merah Strip 2">Merah Strip 2</option>
        </select>
        <button id="update-sabuk">Update Sabuk</button>
    </div>


<script>
const dojangMap = {
    'BWPK': 'Balai Warga Pondok Kelapa',
    'SDTS': 'SD Tiara School',
    'SDTK': 'SD Tunas Karya 2',
    'SMP6': 'SMPN 6 Jakarta',
    'SMA107': 'SMAN 107 Jakarta',
    'EPA': 'East Park Apartment',
    'RBHIN': 'RPTRA Bhineka (EPRA)',
    'ALAC': 'Alhuda Academy (EPRA)',
    'PKB': 'Pakubuwono (EPRA)',
    'SBSD': 'Sekolah Sinarmas BSD',
    'PRV': 'Private',
    'TMMLK': 'Taman Malaka'
};

const namaBulan = ['', 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
                   'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];

function loadSiswaData(nomor) {
    fetch(`/get_data_siswa.php?nomor=${encodeURIComponent(nomor)}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                const s = data.siswa;
                const iuran = data.iuran || [];
                const prestasi = data.prestasi || [];

                document.getElementById('img-siswa').src = `../uploads/foto/${s.nomor_registrasi}.jpg`;
                const sabukFile = (s.sabuk || 'putih').toLowerCase().replace(/[\s-]/g, '_');
                document.getElementById('img-sabuk').src = `../sabuk/${sabukFile}.png`;
                document.getElementById('nama-siswa').textContent = s.nama_lengkap;
                document.getElementById('nomor-siswa').textContent = s.nomor_registrasi;
                document.getElementById('dojang-siswa').textContent = dojangMap[s.kode_dojang] || s.kode_dojang;
                document.getElementById('alamat-siswa').textContent = s.alamat_lengkap;
                document.getElementById('nohp-siswa').textContent = s.no_hp;
                document.getElementById('ttl-siswa').textContent = s.tempat_tgl_lahir;
                document.getElementById('nomor-sertifikat-siswa').textContent = s.nomor_sertifikat || '';
                document.getElementById('tabel-iuran').innerHTML = '';
                document.getElementById('input-sertifikat').value = s.nomor_sertifikat || '';
                document.getElementById('select-sabuk').value = s.sabuk || 'Putih';

                const tbodyIuran = document.getElementById('tabel-iuran');
                tbodyIuran.innerHTML = '';
                if (iuran.length === 0) {
                    tbodyIuran.innerHTML = '<tr><td colspan="4">Tidak ada data iuran</td></tr>';
                } else {
                    iuran.forEach(row => {
                        const tr = document.createElement('tr');
                        tr.innerHTML = `
                            <td>${row.bulan}</td>
                            <td>${row.tahun}</td>
                            <td>${row.status}</td>
                            <td>${row.tipe_pembayaran}</td>
                        `;
                        tbodyIuran.appendChild(tr);
                    });
                }
                
                renderAbsensi(data.absensi || []);
                renderDokumen(s.nomor_registrasi);

                renderPrestasi(prestasi);
                document.getElementById('prestasi-container').style.display = 'block'; // Tampilkan prestasi
                document.getElementById('info-siswa').style.display = 'block';
            } else {
                alert(data.message || 'Gagal ambil data siswa');
            }
        });
}



// Toggle edit container visibility
document.getElementById("edit-alamat").addEventListener("click", function() {
    const alamatContainer = document.getElementById("edit-alamat-container");
    alamatContainer.style.display = alamatContainer.style.display === "none" || alamatContainer.style.display === "" ? "block" : "none";
});

document.getElementById("edit-nohp").addEventListener("click", function() {
    const nohpContainer = document.getElementById("edit-nohp-container");
    nohpContainer.style.display = nohpContainer.style.display === "none" || nohpContainer.style.display === "" ? "block" : "none";
});

document.getElementById("edit-ttl").addEventListener("click", function() {
    const ttlContainer = document.getElementById("edit-ttl-container");
    ttlContainer.style.display = ttlContainer.style.display === "none" || ttlContainer.style.display === "" ? "block" : "none";
});

document.getElementById("edit-sertifikat").addEventListener("click", function() {
    const sertifikatContainer = document.getElementById("edit-sertifikat-container");
    sertifikatContainer.style.display = sertifikatContainer.style.display === "none" || sertifikatContainer.style.display === "" ? "block" : "none";
});

// Update data actions
document.getElementById("update-alamat").addEventListener("click", function() {
    const newAlamat = document.getElementById("input-alamat").value.trim();
    const nomor = document.getElementById('nomor-siswa').textContent.trim(); // Get nomor siswa

    if (!newAlamat) return alert('Alamat tidak boleh kosong!');
    
    fetch(window.location.href, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: new URLSearchParams({
            aksi: 'update_data_siswa',
            nomor_registrasi: nomor,
            alamat: newAlamat
        })
    })
    .then(res => res.json())
    .then(data => {
        alert(data.message);
        if (data.status === 'success') {
            document.getElementById("alamat-siswa").textContent = newAlamat;
            document.getElementById("edit-alamat-container").style.display = "none";
        }
    });
});

document.getElementById("update-nohp").addEventListener("click", function() {
    const newNoHp = document.getElementById("input-nohp").value.trim();
    const nomor = document.getElementById('nomor-siswa').textContent.trim(); // Get nomor siswa

    if (!newNoHp) return alert('Nomor HP tidak boleh kosong!');
    
    fetch(window.location.href, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: new URLSearchParams({
            aksi: 'update_data_siswa',
            nomor_registrasi: nomor,
            no_hp: newNoHp
        })
    })
    .then(res => res.json())
    .then(data => {
        alert(data.message);
        if (data.status === 'success') {
            document.getElementById("nohp-siswa").textContent = newNoHp;
            document.getElementById("edit-nohp-container").style.display = "none";
        }
    });
});

document.getElementById("update-ttl").addEventListener("click", function() {
    const newTtl = document.getElementById("input-ttl").value.trim();
    const nomor = document.getElementById('nomor-siswa').textContent.trim(); // Get nomor siswa

    if (!newTtl) return alert('Tempat dan tanggal lahir tidak boleh kosong!');
    
    fetch(window.location.href, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: new URLSearchParams({
            aksi: 'update_data_siswa',
            nomor_registrasi: nomor,
            tempat_tgl_lahir: newTtl
        })
    })
    .then(res => res.json())
    .then(data => {
        alert(data.message);
        if (data.status === 'success') {
            document.getElementById("ttl-siswa").textContent = newTtl;
            document.getElementById("edit-ttl-container").style.display = "none";
        }
    });
});



// Toggle edit container visibility for Nomor Sertifikat


// Update Nomor Sertifikat
document.getElementById("update-sertifikat").addEventListener("click", function() {
    const newNomorSertifikat = document.getElementById("input-sertifikat").value.trim();
    const nomor = document.getElementById('nomor-siswa').textContent.trim(); // Get nomor siswa

    if (!newNomorSertifikat) return alert('Nomor Sertifikat tidak boleh kosong!');
    
    fetch(window.location.href, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: new URLSearchParams({
            aksi: 'update_siswa',
            nomor_registrasi: nomor,
            nomor_sertifikat: newNomorSertifikat
        })
    })
    .then(res => res.json())
    .then(data => {
        alert(data.message);
        if (data.status === 'success') {
            document.getElementById("nomor-sertifikat-siswa").textContent = newNomorSertifikat;
            document.getElementById("edit-sertifikat-container").style.display = "none";
        }
    });
});

// Update Sabuk
document.getElementById("update-sabuk").addEventListener("click", function() {
    const nomor = document.getElementById('nomor-siswa').textContent.trim(); // Get nomor siswa
    const sabuk = document.getElementById('select-sabuk').value;

    if (!nomor) return alert('Data siswa belum dimuat!');

    fetch(window.location.href, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: new URLSearchParams({
            aksi: 'update_siswa',
            nomor_registrasi: nomor,
            sabuk: sabuk
        })
    })
    .then(res => res.json())
    .then(data => {
        alert(data.message);
        if (data.status === 'success') {
            // Update sabuk langsung di UI tanpa refresh
            const sabukFile = sabuk.toLowerCase().replace(/[\s-]/g, '_');
            document.getElementById('img-sabuk').src = `../sabuk/${sabukFile}.png`;
        }
    });
});



// Muat data otomatis pakai session nomor registrasi
document.addEventListener('DOMContentLoaded', () => {
    loadSiswaData('<?= $nomor ?>');
});
</script>

</body>
</html>
