<?php
session_start();
include '../db.php';

// Cek akses
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

$nomor = $_SESSION['nomor_registrasi'] ?? '';
if (!$nomor) {
    exit('Nomor registrasi tidak ditemukan.');
}

// Ambil nama file foto lama
$stmt = $pdo->prepare("SELECT foto FROM siswa WHERE nomor_registrasi = ?");
$stmt->execute([$nomor]);
$data = $stmt->fetch();
if (!$data) exit('Data siswa tidak ditemukan.');

$foto_lama = $data['foto']; // Contoh: uploads/foto/BWPK-005.jpg
$target_path = '../' . $foto_lama;

// Proses unggah file baru
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['image'])) {
    $img_data = file_get_contents($_FILES['image']['tmp_name']);

    // Coba simpan file
    if (file_put_contents($target_path, $img_data)) {
        echo "<script>alert('Foto berhasil diperbarui.'); window.location.href='idcard.php';</script>";
        exit;
    } else {
        echo "<script>alert('Gagal menyimpan foto.');</script>";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Edit Foto</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" />
  <style>
    body { font-family: sans-serif; padding: 20px; text-align: center; }
    #preview { max-width: 100%; max-height: 400px; }
    .btn { margin-top: 10px; padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; }
  </style>
</head>
<body>

<h2>Ganti Foto Profil</h2>
<form id="form" method="POST" enctype="multipart/form-data">
  <input type="file" id="input-image" accept="image/*" required />
  <br>
  <img id="preview" src="#" style="display:none;" />
  <br>
  <button class="btn" id="saveBtn" type="submit" style="display:none;">Simpan Foto</button>
</form>

<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
<script>
  let cropper;
  const input = document.getElementById('input-image');
  const preview = document.getElementById('preview');
  const saveBtn = document.getElementById('saveBtn');
  const form = document.getElementById('form');

  input.addEventListener('change', (e) => {
    const file = e.target.files[0];
    if (!file) return;

    const url = URL.createObjectURL(file);
    preview.src = url;
    preview.style.display = 'block';

    preview.onload = () => {
      if (cropper) cropper.destroy();
      cropper = new Cropper(preview, {
        aspectRatio: 1,
        viewMode: 1
      });
      saveBtn.style.display = 'inline-block';
    };
  });

  form.addEventListener('submit', function (e) {
    e.preventDefault();
    if (!cropper) return;

    cropper.getCroppedCanvas({ width: 300, height: 300 }).toBlob(function (blob) {
      const formData = new FormData();
      formData.append('image', blob, 'foto.jpg'); // Nama file tidak terlalu penting, akan disimpan ke target_path di PHP

      fetch('', {
        method: 'POST',
        body: formData
      })
      .then(response => response.text())
      .then(result => {
        document.open();
        document.write(result); // Menampilkan alert dan redirect dari PHP
        document.close();
      })
      .catch(error => {
        alert('Gagal mengirim gambar.');
        console.error(error);
      });
    }, 'image/jpeg');
  });
</script>

</body>
</html>
