<?php
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php-error.log');
ini_set('display_errors', 0);
error_reporting(E_ALL);

session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

include '../db.php';

$nomor_registrasi = $_SESSION['nomor_registrasi'];

$stmt = $pdo->prepare("SELECT nomor_registrasi, nama_lengkap, kode_dojang, sabuk FROM siswa WHERE nomor_registrasi = ?");
$stmt->execute([$nomor_registrasi]);
$siswa = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$siswa) die('Data siswa tidak ditemukan.');

// Mapping
$dojang_map = [
    'BWPK' => 'Balai Warga Pondok Kelapa',
    'SDTS' => 'SD Tiara School',
    'SDTK' => 'SD Tunas Karya 2',
    'SMP6' => 'SMPN 6 Jakarta',
    'SMA107' => 'SMAN 107 Jakarta',
    'EPA' => 'East Park Apartment',
    'RBHIN' => 'RPTRA Bhineka (EPRA)',
    'ALAC' => 'Alhuda Academy (EPRA)',
    'PKB' => 'Pakubuwono (EPRA)',
    'SBSD' => 'Sekolah Sinarmas BSD',
    'PRV' => 'Private',
    'TMMLK' => 'Taman Malaka'
];

$pelatih_map = [
    'Galih' => [
        'dojang' => ['BWPK', 'SDTS', 'SDTK', 'SMP6', 'RBHIN', 'ALAC', 'PKB', 'SBSD', 'PRV'],
        'email' => 'galih@example.com',
        'wa'    => '62812xxxxxxx',
        'rekening' => [
            'BCA' => ['norek' => '111122223333', 'atas_nama' => 'Galih Wicaksana', 'logo' => '../assets/bank/bca.png'],
            'Mandiri' => ['norek' => '444455556666', 'atas_nama' => 'Galih Wicaksana', 'logo' => '../assets/bank/mandiri.png']
        ]
    ],
    'Wedu' => [
        'dojang' => ['EPA', 'TMMLK'],
        'email' => 'momentumtkdclub@gmail.com',
        'wa'    => '6281298982082',
        'rekening' => [
            'BCA' => ['norek' => '5035091979', 'atas_nama' => 'Wayan Eka Dharma Utama', 'logo' => '../assets/bank/bca.png'],
            'Mandiri' => ['norek' => '145 00 1119905 2', 'atas_nama' => 'Wayan Eka Dharma Utama', 'logo' => '../assets/bank/mandiri.png'],
            'BNI' => ['norek' => '0430918714', 'atas_nama' => 'Wayan Eka Dharma Utama', 'logo' => '../assets/bank/bni.png']
        ]
    ],
    'Pridi' => [
        'dojang' => ['SMA107'],
        'email' => 'pridi@example.com',
        'wa'    => '62814xxxxxxx',
        'rekening' => [
            'BRI' => ['norek' => '000011112222', 'atas_nama' => 'Pridi', 'logo' => '../assets/bank/bri.png']
        ]
    ]
];
$qris_static_map = [
    'Galih' => '../assets/qris_static/galih.png',
    'Wedu' => '../assets/qris_static/wedu.png',
    'Pridi' => '../assets/qris_static/pridi.png',
];

// ✅ Perbaiki tripay_config
$tripay_config = [
    'Galih' => [
        'api_key' => 'APIKEY_GALIH',
        'merchant_code' => 'MERCH_GALIH',
        'private_key' => 'PRIVATE_KEY_GALIH'
    ],
    'Wedu' => [
        'api_key' => 'DEV-tTtKMXDgGuguoMPqX5PDZ74z9hgSGybLZCCrImty',
        'merchant_code' => 'T40907',
        'private_key' => 'EGHmr-UhBE1-MlF3M-wgRjb-r2rw0'
    ],
    'Pridi' => [
        'api_key' => 'APIKEY_PRIDI',
        'merchant_code' => 'MERCH_PRIDI',
        'private_key' => 'PRIVATE_KEY_PRIDI'
    ]
];

// Fungsi bantu
function getPelatihByDojang($kode, $map) {
    foreach ($map as $nama => $data) {
        if (in_array($kode, $data['dojang'])) return $nama;
    }
    return null;
}

function getPelatihRekening($kode, $map) {
    foreach ($map as $nama => $data) {
        if (in_array($kode, $data['dojang'])) return $data['rekening'];
    }
    return [];
}

function kirimNotifikasiPelatih($pelatih, $pesan) {
    global $pdo, $pelatih_map;
    if (!isset($pelatih_map[$pelatih])) return;
    $data = $pelatih_map[$pelatih];

    $pdo->prepare("INSERT INTO notifikasi (pelatih, isi) VALUES (?, ?)")
        ->execute([$pelatih, $pesan]);

    if (!empty($data['email'])) {
        @mail($data['email'], 'Notifikasi Pembayaran', $pesan);
    }

    if (!empty($data['wa'])) {
        $wa_url = 'https://app.wapanels.com/api/create-message';
        $payload = [
            'appkey' => '7d0df1d5-dabe-4d97-9fe2-9a9ae15bb6b6',
            'authkey' => '1PCBMIfex9Hy0fsqGKuuvB722KA5S8hTfdWPNW7VULLKs6jQE2',
            'to' => $data['wa'],
            'message' => $pesan
        ];

        $ch = curl_init($wa_url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $payload
        ]);
        curl_exec($ch);
        curl_close($ch);
    }
}

// Gambar sabuk & foto
$foto_path = '../uploads/foto/' . $siswa['nomor_registrasi'] . '.jpg';
function formatSabukImgName($sabukName) {
    return str_replace([' ', '-'], '_', strtolower($sabukName));
}
$sabuk_gambar = '../sabuk/' . formatSabukImgName($siswa['sabuk'] ?? 'putih') . '.png';
$bank_list = getPelatihRekening($siswa['kode_dojang'], $pelatih_map);
$nama_bulan = [
    1 => 'Januari', 2 => 'Februari', 3 => 'Maret', 4 => 'April',
    5 => 'Mei', 6 => 'Juni', 7 => 'Juli', 8 => 'Agustus',
    9 => 'September', 10 => 'Oktober', 11 => 'November', 12 => 'Desember'
];

// 🧾 Proses form iuran
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_iuran'])) {
    $bulan = (int) ($_POST['bulan'] ?? 0);
    $tahun = (int) ($_POST['tahun'] ?? 0);
    $tipe_pembayaran = $_POST['tipe_pembayaran'] ?? '';
    $bank_tujuan = $_POST['bank_tujuan'] ?? '';
    $uploadBukti = null;

    if ($tipe_pembayaran === 'qris_api') {
        $_SESSION['nama_lengkap'] = $siswa['nama_lengkap'];
        $_SESSION['kode_dojang'] = $siswa['kode_dojang'];
        header("Location: ../gateway/tripay.php?bulan=$bulan&tahun=$tahun");
        exit;
    }

    // Validasi input
    if ($bulan < 1 || $bulan > 12 || $tahun < 2000) {
        $error = "Bulan atau tahun tidak valid.";
    } elseif (!in_array($tipe_pembayaran, ['transfer', 'qris'])) {
        $error = "Metode pembayaran tidak valid.";
    }

    // Cek duplikat
    if (!isset($error)) {
        $cek = $pdo->prepare("SELECT COUNT(*) FROM iuran WHERE nomor_registrasi = ? AND bulan = ? AND tahun = ?");
        $cek->execute([$nomor_registrasi, $bulan, $tahun]);
        if ($cek->fetchColumn() > 0) {
            $error = "Iuran untuk bulan dan tahun tersebut sudah diajukan.";
        }
    }

    // Transfer bank logic
    if (!isset($error) && $tipe_pembayaran === 'transfer') {
        if (!array_key_exists($bank_tujuan, $bank_list)) {
            $error = "Bank tujuan tidak valid.";
        }

        if (isset($_FILES['bukti_transfer']) && $_FILES['bukti_transfer']['error'] === UPLOAD_ERR_OK) {
            $ext = strtolower(pathinfo($_FILES['bukti_transfer']['name'], PATHINFO_EXTENSION));
            $allowed = ['jpg', 'jpeg', 'png', 'pdf'];
            if (!in_array($ext, $allowed)) {
                $error = "Format file tidak didukung.";
            } else {
                $uploadDir = __DIR__ . '/../bukti_transfer/';
                if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
                $filename = 'bukti_' . $nomor_registrasi . '_' . time() . '.' . $ext;
                $dest = $uploadDir . $filename;
                if (move_uploaded_file($_FILES['bukti_transfer']['tmp_name'], $dest)) {
                    $uploadBukti = $filename;
                } else {
                    $error = "Gagal upload bukti transfer.";
                }
            }
        } else {
            $error = "Bukti transfer wajib diupload.";
        }
    }

    // Simpan data iuran
    if (!isset($error)) {
        $stmtInsert = $pdo->prepare("INSERT INTO iuran (nomor_registrasi, bulan, tahun, status, tipe_pembayaran, bukti_transfer, bank_tujuan) VALUES (?, ?, ?, 'pending', ?, ?, ?)");
        $stmtInsert->execute([$nomor_registrasi, $bulan, $tahun, $tipe_pembayaran, $uploadBukti, $bank_tujuan]);
        $success = "Permintaan iuran berhasil dikirim. Silakan tunggu verifikasi.";

        $pelatih = getPelatihByDojang($siswa['kode_dojang'], $pelatih_map);
        $isi = "📝 Siswa {$siswa['nama_lengkap']} ({$siswa['nomor_registrasi']}) mengirim iuran bulan $bulan/$tahun via $tipe_pembayaran. Mohon dicek.";
        kirimNotifikasiPelatih($pelatih, $isi);
    }
}
?>
<!-- QRIS Statis -->
<?php if ($_POST['tipe_pembayaran'] ?? '' === 'qris' && !isset($error)): ?>
    <?php 
        $pelatih = getPelatihByDojang($siswa['kode_dojang'], $pelatih_map);
        $qris_image = $qris_static_map[$pelatih] ?? '../assets/qris_static/default.png';
    ?>
    <div style="margin-top:20px; text-align:center;">
        <h4>Scan QRIS:</h4>
        <img src="<?= $qris_image ?>" alt="QRIS" style="width:300px;">
        <p><strong>Catatan:</strong> Tunggu verifikasi admin setelah pembayaran.</p>
    </div>
<?php endif; ?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Iuran Auto - Siswa</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            margin: 20px auto;
            max-width: 700px;
            background-color: #f9f9f9;
            color: #333;
        }
        h2, h3, h4 {
            color: #2c3e50;
            margin-top: 30px;
            text-align: center;
        }
        form {
            background: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.07);
            margin-bottom: 30px;
        }
        select, input[type="file"], button {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 6px;
            margin-top: 5px;
            font-size: 1em;
        }
        button {
            background-color: #3498db;
            color: white;
            border: none;
            font-weight: bold;
            cursor: pointer;
        }
        button:hover {
            background-color: #2980b9;
        }
        .radio-group {
            margin: 15px 0;
        }
        .radio-group label {
            margin-right: 15px;
        }
        .message {
            padding: 10px;
            border-radius: 6px;
            margin-top: 15px;
            font-weight: bold;
        }
        .success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .error   { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            box-shadow: 0 0 5px rgba(0,0,0,0.05);
        }
        thead { background-color: #2980b9; color: white; }
        th, td {
            padding: 12px 10px;
            text-align: center;
            border-bottom: 1px solid #ddd;
        }
        .foto-siswa, .sabuk-siswa {
            width: 150px;
            border-radius: 6px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
        }
        .btn-back {
            display: inline-block;
            background: #7f8c8d;
            color: #fff;
            padding: 10px 20px;
            border-radius: 6px;
            text-decoration: none;
        }
        .btn-back:hover {
            background: #5f6a6a;
        }
        #copyMsg {
            display: none;
            font-size: 0.9em;
            color: green;
        }
    </style>
</head>
<body>

<h2>Menu Pembayaran Iuran Momentum Taekwondo Club</h2>

<!-- Siswa Info -->
<div style="text-align: center;">
    <?php if (file_exists($foto_path)): ?>
        <img src="<?= $foto_path ?>" class="foto-siswa" alt="Foto"><br>
    <?php endif; ?>
    <?php if (file_exists($sabuk_gambar)): ?>
        <img src="<?= $sabuk_gambar ?>" class="sabuk-siswa" alt="Sabuk"><br>
    <?php endif; ?>
    <p>
        <strong><?= htmlspecialchars($siswa['nama_lengkap']) ?></strong><br>
        <strong>No. Registrasi:</strong> <?= $siswa['nomor_registrasi'] ?><br>
        <strong>Dojang:</strong> <?= htmlspecialchars($dojang_map[$siswa['kode_dojang']] ?? 'Unknown Dojang') ?><br>
        <strong>Sabuk:</strong> <?= $siswa['sabuk'] ?>
    </p>
</div>

<!-- Form -->
<form method="post" enctype="multipart/form-data">
    <label for="bulan">Bulan:</label>
    <select name="bulan" required>
        <option value="">-- Pilih Bulan --</option>
        <?php foreach ($nama_bulan as $num => $nama): ?>
            <option value="<?= $num ?>" <?= ($_POST['bulan'] ?? '') == $num ? 'selected' : '' ?>><?= $nama ?></option>
        <?php endforeach; ?>
    </select>

    <label for="tahun">Tahun:</label>
    <select name="tahun" required>
        <?php $th = date('Y'); for ($i = $th - 1; $i <= $th + 5; $i++): ?>
            <option value="<?= $i ?>" <?= ($_POST['tahun'] ?? '') == $i ? 'selected' : '' ?>><?= $i ?></option>
        <?php endfor; ?>
    </select>

    <div class="radio-group">
        <label><input type="radio" name="tipe_pembayaran" value="transfer" <?= ($_POST['tipe_pembayaran'] ?? '') === 'transfer' ? 'checked' : '' ?>> Transfer</label>
        <label><input type="radio" name="tipe_pembayaran" value="qris" <?= ($_POST['tipe_pembayaran'] ?? '') === 'qris' ? 'checked' : '' ?>> QRIS Statis</label>
        <label><input type="radio" name="tipe_pembayaran" value="qris_api" <?= ($_POST['tipe_pembayaran'] ?? '') === 'qris_api' ? 'checked' : '' ?>> QRIS Otomatis</label>
    </div>

    <div id="uploadField" style="display:none;">
        <label>Upload Bukti Transfer:</label>
        <input type="file" name="bukti_transfer" accept=".jpg,.jpeg,.png,.pdf">
    </div>

    <div id="bank-section" style="display:none;">
        <label>Pilih Bank:</label>
        <select name="bank_tujuan" id="bank_tujuan">
            <option value="">-- Pilih Bank --</option>
            <?php foreach ($bank_list as $bank => $data): ?>
                <option value="<?= $bank ?>" <?= ($_POST['bank_tujuan'] ?? '') === $bank ? 'selected' : '' ?>><?= $bank ?></option>
            <?php endforeach; ?>
        </select>
        <div id="info_bank" style="margin-top:10px;"></div>
        <div id="copyMsg">✅ No. rekening disalin!</div>
    </div>

    <button type="submit" name="submit_iuran">Bayar Iuran</button>
</form>

<!-- Notifikasi -->
<?php if (isset($error)): ?>
    <div class="message error"><?= htmlspecialchars($error) ?></div>
<?php elseif (isset($success)): ?>
    <div class="message success"><?= htmlspecialchars($success) ?></div>
<?php endif; ?>
<!-- Histori Iuran -->
<hr style="margin-top:40px; margin-bottom:20px;">
<h3>Histori Iuran Saya</h3>

<form method="get" style="margin-bottom:10px;">
    <label>Pilih Tahun:
        <select name="filter_tahun" onchange="this.form.submit()">
            <?php 
            $yearNow = date('Y');
            $filter_tahun = (int) ($_GET['filter_tahun'] ?? $yearNow);
            for ($y = $yearNow - 1; $y <= $yearNow + 2; $y++): ?>
                <option value="<?= $y ?>" <?= ($filter_tahun == $y ? 'selected' : '') ?>><?= $y ?></option>
            <?php endfor; ?>
        </select>
    </label>
</form>

<?php
$stmt = $pdo->prepare("SELECT * FROM iuran WHERE nomor_registrasi = ? AND tahun = ? ORDER BY tahun DESC, bulan DESC");
$stmt->execute([$nomor_registrasi, $filter_tahun]);
$iuran = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<?php if (count($iuran) === 0): ?>
    <p>Tidak ada iuran di tahun <?= $filter_tahun ?>.</p>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>Bulan</th>
                <th>Status</th>
                <th>Metode</th>
                <th>Bukti</th>
                <th>QR</th>
                <th>Verifikasi</th>
                <th>Waktu</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($iuran as $row): ?>
            <tr>
                <td><?= $nama_bulan[$row['bulan']] ?? $row['bulan'] ?> <?= $row['tahun'] ?></td>
                <td>
                    <?php
                    if ($row['status'] === 'lunas') echo '✅ Lunas';
                    elseif ($row['status'] === 'pending') echo '⏳ Pending';
                    else echo '❌ Gagal';
                    ?>
                </td>
                <td><?= htmlspecialchars($row['tipe_pembayaran']) ?></td>
                <td>
                    <?php if ($row['bukti_transfer']): ?>
                        <a href="../bukti_transfer/<?= $row['bukti_transfer'] ?>" target="_blank">Lihat</a>
                    <?php else: ?> -
                    <?php endif; ?>
                </td>
                <td>
                    <?php if ($row['payment_url'] && $row['tipe_pembayaran'] === 'qris_api'): ?>
                        <a href="<?= $row['payment_url'] ?>" target="_blank">QRIS</a>
                    <?php else: ?> -
                    <?php endif; ?>
                </td>
                <td><?= $row['paraf_pelatih'] ?: '-' ?></td>
                <td><?= $row['waktu_bayar'] ?: '-' ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

<a href="dashboard.php" class="btn-back">← Kembali ke Dashboard</a>

<!-- JavaScript -->
<script>
const bankInfo = <?= json_encode($bank_list, JSON_UNESCAPED_SLASHES) ?>;

function updateBankInfo() {
    const val = document.getElementById('bank_tujuan')?.value;
    const info = bankInfo[val];
    const container = document.getElementById('info_bank');
    if (info) {
        container.innerHTML = `
            <img src="${info.logo}" alt="${val}" style="width:100px;"><br>
            <strong>No. Rek:</strong> <span id="norekText">${info.norek}</span><br>
            <strong>Atas Nama:</strong> ${info.atas_nama}<br>
            <button type="button" onclick="copyNorek()">Salin No. Rekening</button>
        `;
    } else {
        container.innerHTML = '';
    }
}

function copyNorek() {
    const norek = document.getElementById('norekText')?.textContent;
    if (norek) {
        navigator.clipboard.writeText(norek).then(() => {
            const msg = document.getElementById('copyMsg');
            msg.style.display = 'block';
            setTimeout(() => msg.style.display = 'none', 2000);
        });
    }
}

// Toggle tampilan upload dan bank berdasarkan metode pembayaran
document.querySelectorAll('input[name="tipe_pembayaran"]').forEach(el => {
    el.addEventListener('change', () => {
        const val = el.value;
        const isTransfer = val === 'transfer';
        document.getElementById('uploadField').style.display = isTransfer ? 'block' : 'none';
        document.getElementById('bank-section').style.display = isTransfer ? 'block' : 'none';
    });
});

// Trigger load saat reload halaman
if (document.querySelector('input[name="tipe_pembayaran"]:checked')?.value === 'transfer') {
    document.getElementById('uploadField').style.display = 'block';
    document.getElementById('bank-section').style.display = 'block';
    updateBankInfo();
}

document.getElementById('bank_tujuan')?.addEventListener('change', updateBankInfo);
</script>

</body>
</html>
