<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'pelatih') {
    header('Location: ../login.php');
    exit;
}

include '../db.php';

// =======================
// 🔁 FUNGSI MAPPING + UTILITY
// =======================

function formatTanggalLahir($tempat_tgl) {
    $parts = explode(',', $tempat_tgl);
    if (count($parts) != 2) return $tempat_tgl;
    $tempat = trim($parts[0]);
    $tgl = trim($parts[1]);
    $dateObj = DateTime::createFromFormat('d-m-Y', $tgl);
    if (!$dateObj) return $tempat_tgl;
    $bulanIndo = [
        1 => 'Januari','Februari','Maret','April','Mei','Juni',
        'Juli','Agustus','September','Oktober','November','Desember'
    ];
    return $tempat . ', ' . $dateObj->format('d') . ' ' . $bulanIndo[(int)$dateObj->format('m')] . ' ' . $dateObj->format('Y');
}

$dojang_map = [
    'BWPK' => 'Balai Warga Pondok Kelapa',
    'SDTS' => 'SD Tiara School',
    'SDTK' => 'SD Tunas Karya 2',
    'SMP6' => 'SMPN 6 Jakarta',
    'SMA107' => 'SMAN 107 Jakarta',
    'EPA' => 'East Park Apartment',
    'RBHIN' => 'RPTRA Bhineka (EPRA)',
    'ALAC' => 'Alhuda Academy (EPRA)',
    'PKB' => 'Pakubuwono (EPRA)',
    'SBSD' => 'Sekolah Sinarmas BSD',
    'PRV' => 'Private',
    'TMMLK' => 'Taman Malaka'
];

$sabuk_to_geup = [
  'Putih' => 'Geup X',
  'Kuning' => 'Geup IX',
  'Kuning Strip' => 'Geup VIII',
  'Hijau' => 'Geup VII',
  'Hijau Strip' => 'Geup VI',
  'Biru' => 'Geup V',
  'Biru Strip' => 'Geup IV',
  'Merah' => 'Geup III',
  'Merah Strip I' => 'Geup II',
  'Merah Strip 2' => 'Geup I',
  'Hitam/Poom' => ' ',
];

$sabuk_levels = [
  'Putih' => 'Kuning',
  'Kuning' => 'Kuning Strip',
  'Kuning Strip' => 'Hijau',
  'Hijau' => 'Hijau Strip',
  'Hijau Strip' => 'Biru',
  'Biru' => 'Biru Strip',
  'Biru Strip' => 'Merah',
  'Merah' => 'Merah Strip I',
  'Merah Strip I' => 'Merah Strip 2',
  'Merah Strip 2' => 'Hitam/Poom',
  'Hitam/Poom' => 'Hitam/Poom',
];

function getNaikSabukDanGeup($sabukSekarang, $sabukLevels, $sabukToGeup) {
    if (!$sabukSekarang || strtolower($sabukSekarang) === 'putih') {
        $naikSabuk = 'Kuning';
        $naikGeup = $sabukToGeup[$naikSabuk] ?? '-';
        return $naikSabuk . ' - ' . $naikGeup;
    }
    $naikSabuk = $sabukLevels[$sabukSekarang] ?? '-';
    $naikGeup = $sabukToGeup[$naikSabuk] ?? '-';
    return $naikSabuk . ' - ' . $naikGeup;
}

// =======================
// 🔎 GET FILTER PARAMETER + TANGGAL UJIAN
// =======================
$filter = $_GET['filter'] ?? 'semua';
$dojang = $_GET['dojang'] ?? '';
$nomor = $_GET['nomor_registrasi'] ?? '';

$tanggalUjianRaw = $_GET['tanggal_ujian'] ?? date('Y-m-d');
$tanggalUjianObj = DateTime::createFromFormat('Y-m-d', $tanggalUjianRaw);
$bulanIndo = [
    1 => 'Januari','Februari','Maret','April','Mei','Juni',
    'Juli','Agustus','September','Oktober','November','Desember'
];
if ($tanggalUjianObj) {
    $tanggalUjian = $tanggalUjianObj->format('d') . ' ' . $bulanIndo[(int)$tanggalUjianObj->format('m')] . ' ' . $tanggalUjianObj->format('Y');
} else {
    $tanggalUjian = '-';
}

$query = "SELECT * FROM siswa";
$params = [];

if ($filter === 'dojang' && $dojang) {
    $query .= " WHERE kode_dojang = ?";
    $params[] = $dojang;
} elseif ($filter === 'siswa' && $nomor) {
    $query .= " WHERE nomor_registrasi = ?";
    $params[] = $nomor;
}

$query .= " ORDER BY kode_dojang, sabuk, nama_lengkap";
$stmt = $pdo->prepare($query);
$stmt->execute($params);
$siswa_list = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$siswa_list) {
    die('Data siswa tidak ditemukan.');
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <title>Cetak Form Nilai UKT</title>
  <style>
    @media print {
      .pagebreak { page-break-after: always; }
    }
    body {
      margin: 0;
      padding: 0;
      font-family: 'Times New Roman', serif;
    }
  </style>
</head>
<body>

<?php foreach($siswa_list as $siswa): ?>

  <?php
    $ttl = formatTanggalLahir($siswa['tempat_tgl_lahir']);
    $sabuk = trim($siswa['sabuk'] ?? '');
    $sabukDisplay = ($sabuk === '' || strtolower($sabuk) === 'putih') ? 'Putih' : $sabuk;
    $naik_sabuk_geup = getNaikSabukDanGeup($sabuk, $sabuk_levels, $sabuk_to_geup);
    $unit = $dojang_map[$siswa['kode_dojang']] ?? $siswa['kode_dojang'];

    $biodata = [
      ['label' => 'Nomor Sertifikat', 'value' => htmlspecialchars($siswa['nomor_sertifikat'] ?? '-')],
      ['label' => 'Sabuk', 'value' => htmlspecialchars($sabukDisplay . ' - ' . ($sabuk_to_geup[$sabukDisplay] ?? '-'))],
      ['label' => 'Naik Sabuk / Geup', 'value' => htmlspecialchars($naik_sabuk_geup)],
      ['label' => 'Nama Lengkap', 'value' => htmlspecialchars($siswa['nama_lengkap'])],
      ['label' => 'Tempat / Tanggal Lahir', 'value' => htmlspecialchars($ttl)],
      ['label' => 'Unit', 'value' => htmlspecialchars($unit)],
    ];

    $materi_list = [
      'Basic (Tendangan, Tangkisan, dan Kuda – Kuda)',
      'Basic, Gibon, Taegeuk',
      'Kyurugi / Sparing',
      'Fisik dan Mental'
    ];
    $nilai_list = [
      '10, 20, 30, 40, 50',
      '10, 20, 30, 40, 50',
      '10, 20, 30, 40, 50',
      '10, 20, 30, 40, 50'
    ];
  ?>

  <div class="form-container" style="width: 800px; height: 1120px; margin: 20px auto; background-image: url('/assets/images/form_nilai.png'); background-size: contain; background-repeat: no-repeat; background-position: top center; padding-top: 180px;">
    <div style="text-align:center; font-weight:bold; font-size:18pt; margin-bottom:30px;">Daftar Nilai Peserta Ujian</div>

    <?php foreach($biodata as $item): ?>
      <div style="display:grid; grid-template-columns:200px 20px 1fr; font-size:14pt; margin-bottom:6px;">
        <div><?= $item['label'] ?></div>
        <div>:</div>
        <div><?= $item['value'] ?></div>
      </div>
    <?php endforeach; ?>

    <div style="display:grid; grid-template-columns:50px 1fr 150px; font-weight:bold; font-size:14pt; margin-top:40px; border-bottom:2px solid black; padding-bottom:6px;">
      <div>NO</div>
      <div>Materi</div>
      <div>Nilai</div>
    </div>

    <?php foreach($materi_list as $i => $materi): ?>
      <div style="display:grid; grid-template-columns:50px 1fr 150px; font-size:14pt; padding:6px 0; border-bottom:1px solid #ccc;">
        <div><?= $i + 1 ?></div>
        <div><?= htmlspecialchars($materi) ?></div>
        <div><?= htmlspecialchars($nilai_list[$i]) ?></div>
      </div>
    <?php endforeach; ?>

    <div style="display:grid; grid-template-columns:250px 150px; font-weight:bold; font-size:14pt; margin-top:10px; border-top:2px solid black; padding-top:6px;">
      <div>Total Nilai</div>
      <div></div>
    </div>

    <div style="margin-top:20px; font-weight:bold; font-size:14pt;">LULUS / MENGULANG / TIDAK LULUS</div>

    <div style="margin-top:50px; font-size:12pt;">
      <div>Jakarta, <?= date('d F Y') ?></div>
      <div style="margin-top:10px; font-size:14pt; font-weight:bold;">
        Tanggal Ujian: <?= htmlspecialchars($tanggalUjian) ?>
      </div>
      <div style="margin-top:50px;">Penguji,</div>
      <div style="margin-top:60px; font-weight:bold;">GM, Ir, M. Anthony SH, MKn</div>
      <div style="font-style: italic;">DAN VIII KUKKIWON</div>

      <div style="margin-top: 90px; font-style: italic; text-align: center;">
        Cek kembali biodata peserta ujian dan jika ada kesalahan data langsung konfirmasi kepada pelatih
      </div>
    </div>
  </div>

  <div class="pagebreak"></div>

<?php endforeach; ?>

</body>
</html>
