<?php
session_start();
require '../db.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

$nomor = $_SESSION['nomor_registrasi'] ?? '';
$stmt = $pdo->prepare("SELECT * FROM siswa WHERE nomor_registrasi = ?");
$stmt->execute([$nomor]);
$data = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$data) die('Data siswa tidak ditemukan.');

$tempat = '';
$tanggal = '';
if (!empty($data['tempat_tgl_lahir'])) {
    $parts = explode(',', $data['tempat_tgl_lahir']);
    $tempat = trim($parts[0] ?? '');
    $tanggal = trim($parts[1] ?? '');
}

function renderBoxes(string $text, int $length): string {
    $text = strtoupper(trim($text));
    $chars = preg_split('//u', $text, null, PREG_SPLIT_NO_EMPTY);
    $html = '<span class="inline-char-boxes">';
    for ($i = 0; $i < $length; $i++) {
        $html .= '<div class="char-box">' . ($chars[$i] ?? '&nbsp;') . '</div>';
    }
    $html .= '</span>';
    return $html;
}

function renderMultiLineBoxes(string $text, int $lineLength = 35, int $lines = 3): string {
    $text = strtoupper(trim($text));
    $chars = preg_split('//u', $text, null, PREG_SPLIT_NO_EMPTY);
    $html = '';
    for ($l = 0; $l < $lines; $l++) {
        $html .= '<div class="inline-char-boxes">';
        for ($i = 0; $i < $lineLength; $i++) {
            $idx = $l * $lineLength + $i;
            $html .= '<div class="char-box">' . ($chars[$idx] ?? '&nbsp;') . '</div>';
        }
        $html .= '</div><br />';
    }
    return $html;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Formulir Ujian Momentum Club</title>
  <style>
    @page {
      size: 21.59cm 35.56cm;
      margin: 1cm;
    }

    body {
      background: url('../assets/images/surat.png') no-repeat center top;
      background-size: cover;
      padding: 300px 30px 10px 30px;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      font-size: 14px;
      margin: 0;
    }

    h2 {
      text-align: center;
      margin-bottom: 30px;
      font-weight: 700;
    }

    table {
      width: 100%;
      border-collapse: collapse;
    }

    td {
      vertical-align: middle;
      padding: 5px;
    }

    .label {
      width: 30%;
      font-weight: 600;
    }

    .inline-char-boxes {
      display: inline-flex;
      gap: 1px;
      vertical-align: middle;
    }

    .char-box {
      width: 20px;
      height: 25px;
      border: 1.5px solid #000;
      text-align: center;
      line-height: 25px;
      font-weight: 700;
      user-select: none;
    }

    .photo-box {
      width: 80px;
      height: 100px;
      border: 1.5px solid #000;
      display: inline-block;
      margin: 30px 10px 0 10px;
      text-align: center;
      line-height: 100px;
      font-weight: 600;
      user-select: none;
    }

    .signature-wrapper {
      display: flex;
      justify-content: space-between;
      margin: 0 2cm;
    }

    .signature-box {
      text-align: center;
      font-size: 14px;
      margin: 0 0;
      user-select: none;
    }

    .label-wrapper {
      display: flex;
      flex-direction: column;
      align-items: center;
      white-space: nowrap;
    }

    .signature-box .label {
      margin-bottom: 60px;
      font-weight: 700;
      font-size: 14px;
    }

    .signature-box .line {
      border-top: 1.5px solid #000;
      width: 150px;
      margin: 10px auto 0 auto;
      transform: translateX(+20px);
    }

    .signature-box .name {
      margin-top: 5px;
      font-weight: bold;
      font-size: 14px;
    }

    #backBtn {
      position: fixed;
      top: 20px;
      left: 20px;
      padding: 10px 15px;
      background-color: #007BFF;
      color: white;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      font-weight: 600;
      z-index: 1000;
      user-select: none;
      box-shadow: 0 2px 6px rgba(0,0,0,0.2);
      transition: background-color 0.3s ease;
    }

    #backBtn:hover {
      background-color: #0056b3;
    }

    /* Responsif untuk perangkat kecil */
    @media (max-width: 768px) {
      body {
        padding: 100px 20px 20px 20px;
        background-size: contain;
      }

      h2 {
        font-size: 18px;
        margin-bottom: 20px;
      }

      .photo-box {
        width: 70px;
        height: 90px;
      }

      .char-box {
        width: 18px;
        height: 22px;
        font-size: 16px;
      }

      .signature-wrapper {
        flex-direction: column;
        align-items: center;
      }

      .signature-box .name {
        font-size: 12px;
      }

      #backBtn {
        display: none;
      }
    }

    /* Styling untuk cetakan */
    @media print {
      body {
        margin: 0 !important;
        padding: 5cm 2cm 2cm 1cm !important;
        background-size: contain !important;
        color: #000 !important;
        font-size: 12px !important;
        -webkit-print-color-adjust: exact !important;
      }

      #backBtn {
        display: none !important;
      }
    }
  </style>
</head>
<body>
  <h2>FORMULIR UJIAN</h2>

  <table>
    <tr>
      <td class="label">Nomor Registrasi</td>
      <td>: <?= renderBoxes($data['nomor_sertifikat'], 20) ?> <i>(Ijazah Tae Kwon Do terakhir)</i></td>
    </tr>
    <tr>
      <td class="label">Nama Lengkap</td>
      <td>: <?= renderBoxes($data['nama_lengkap'], 30) ?></td>
    </tr>
    <tr>
      <td class="label">Tempat / Tgl Lahir</td>
      <td>: <?= renderBoxes($tempat, 20) ?> / <?= renderBoxes($tanggal, 10) ?> <i>(tgl-bln-thn)</i></td>
    </tr>
    <tr>
      <td class="label">Jenis Kelamin</td>
      <td>: 
        <span class="box"><?= ($data['jenis_kelamin'] ?? '') === 'L' ? 'x' : '&nbsp;' ?></span> Laki – Laki &nbsp;&nbsp;
        <span class="box"><?= ($data['jenis_kelamin'] ?? '') === 'P' ? 'x' : '&nbsp;' ?></span> Perempuan
        <i>beri tanda (x)</i>
      </td>
    </tr>
    <tr>
      <td class="label">Pekerjaan</td>
      <td>: <?= renderBoxes($data['pekerjaan'] ?? '-', 25) ?></td>
    </tr>
    <tr>
      <td class="label">Alamat Lengkap</td>
      <td>: <br><?= renderMultiLineBoxes($data['alamat_lengkap'] ?? '-', 35, 3) ?></td>
    </tr>
    <tr>
      <td class="label">No. HP Siswa</td>
      <td>: <?= renderBoxes($data['no_hp'] ?? '-', 20) ?></td>
    </tr>
    <tr>
      <td class="label">No. HP Wali</td>
      <td>: <?= renderBoxes($data['no_hp_wali'] ?? '-', 20) ?></td>
    </tr>
    <tr>
      <td class="label">Nama Orang Tua</td>
      <td>: <?= renderBoxes($data['nama_wali'] ?? '-', 25) ?></td>
    </tr>
    <tr>
      <td class="label">Pekerjaan Orang Tua</td>
      <td>: <?= renderBoxes($data['pekerjaan_ortu'] ?? '-', 25) ?></td>
    </tr>
  </table>

  <p class="section-title">Kelengkapan Adm (Diisi oleh Pelatih)</p>
  <table>
    <tr>
      <td>Iuran</td>
      <td>: Sudah <span class="box"></span></td>
      <td>Gashuku</td>
      <td>: Sudah <span class="box"></span></td>
    </tr>
    <tr>
      <td>Biaya Ujian</td>
      <td>: Sudah <span class="box"></span></td>
      <td>Foto</td>
      <td>: Sudah <span class="box"></span></td>
    </tr>
  </table>

  <p class="section-title">Tingkatan / Sabuk Terakhir: <?= htmlspecialchars($data['sabuk'] ?? '________________') ?></p>

  <!-- Foto -->
  <div class="photo-section">
    <div class="photo-box">3 x 4</div>
    <div class="photo-box">3 x 4</div>
    <div class="photo-box">3 x 4</div>
    <div class="photo-box">3 x 4</div>
  </div>

  <!-- Tanda tangan -->
  <div class="signature-area">
    <div class="signature-wrapper">
      <div class="signature-box">
        <div class="label-wrapper">
          <div class="label">Taekwondoin</div>
          <div class="name name-taekwondoin"><?= htmlspecialchars($data['nama_lengkap']) ?></div>
          <div class="line line-taekwondoin"></div>
        </div>
      </div>
      <div class="signature-box">
        <div class="label-wrapper">
          <div class="label">Orang Tua / Wali</div>
          <div class="name name-wali"><?= htmlspecialchars($data['nama_wali'] ?? '-') ?></div>
          <div class="line line-wali"></div>
        </div>
      </div>
    </div>
  </div>

  <button id="backBtn">Kembali ke Dashboard</button>

</body>
</html>

