<?php

session_start();
include '../db.php';

// Pastikan user sudah login dan memiliki role siswa
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

$nomor_registrasi = $_SESSION['nomor_registrasi'] ?? '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password_lama = $_POST['password_lama'] ?? '';
    $password_baru = $_POST['password_baru'] ?? '';
    $konfirmasi_password = $_POST['konfirmasi_password'] ?? '';

    // Validasi input
    if ($password_baru !== $konfirmasi_password) {
        // Mengarahkan kembali jika password baru dan konfirmasi tidak cocok
        header('Location: ganti_password.php?error=password_mismatch');
        exit;
    }

    // Ambil password lama dari tabel user berdasarkan nomor registrasi
    $stmt = $pdo->prepare("SELECT password FROM users WHERE nomor_registrasi = ?");
    $stmt->execute([$nomor_registrasi]);
    $data = $stmt->fetch(PDO::FETCH_ASSOC);

    // Jika user tidak ditemukan atau password lama salah
    if (!$data || $data['password'] !== $password_lama) {
        // Mengarahkan kembali jika password lama salah
        header('Location: ganti_password.php?error=password_lama_salah');
        exit;
    }

    // Update password baru di tabel user
    $updateStmt = $pdo->prepare("UPDATE users SET password = ? WHERE nomor_registrasi = ?");
    if ($updateStmt->execute([$password_baru, $nomor_registrasi])) {
        // Password berhasil diubah, redirect ke dashboard
        header('Location: dashboard.php?success=password_changed');
        exit;
    } else {
        // Jika gagal, arahkan ke halaman dengan error
        header('Location: ganti_password.php?error=update_failed');
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <title>Ganti Password</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f9f9f9;
            margin: 0;
            padding: 0 20px;
        }
        form {
            margin: 50px auto;
            max-width: 400px;
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }
        label {
            font-weight: 600;
            margin-bottom: 5px;
        }
        input {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 6px;
            border: 1px solid #ccc;
            font-size: 16px;
        }
        button {
            background: #007BFF;
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 6px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }
        button:hover {
            background-color: #0056b3;
        }
        .error-message {
            color: red;
            font-weight: bold;
        }
        .success-message {
            color: green;
            font-weight: bold;
        }
    </style>
</head>
<body>

<h2>Ganti Password</h2>

<?php
// Tampilkan pesan error atau sukses jika ada
if (isset($_GET['error'])) {
    if ($_GET['error'] === 'password_mismatch') {
        echo '<p class="error-message">Password baru dan konfirmasi tidak cocok!</p>';
    } elseif ($_GET['error'] === 'password_lama_salah') {
        echo '<p class="error-message">Password lama salah!</p>';
    } elseif ($_GET['error'] === 'update_failed') {
        echo '<p class="error-message">Gagal mengubah password, coba lagi.</p>';
    }
} elseif (isset($_GET['success'])) {
    if ($_GET['success'] === 'password_changed') {
        echo '<p class="success-message">Password berhasil diubah!</p>';
    }
}
?>

<form action="ganti_password.php" method="POST">
    <label for="password_lama">Password Lama</label>
    <input type="password" id="password_lama" name="password_lama" required>

    <label for="password_baru">Password Baru</label>
    <input type="password" id="password_baru" name="password_baru" required>

    <label for="konfirmasi_password">Konfirmasi Password Baru</label>
    <input type="password" id="konfirmasi_password" name="konfirmasi_password" required>

    <button type="submit">Ganti Password</button>
</form>

</body>
</html>
