<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

include '../db.php';

$nomor = $_SESSION['nomor_registrasi'] ?? '';
if (!$nomor) {
    die('Nomor registrasi siswa tidak ditemukan di sesi.');
}

// Ambil data siswa
$stmt = $pdo->prepare("SELECT * FROM siswa WHERE nomor_registrasi = ?");
$stmt->execute([$nomor]);
$siswa = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$siswa) {
    die('Data siswa tidak ditemukan.');
}

// Map dojang
$dojang_map = [
    'BWPK'   => 'Balai Warga Pondok Kelapa',
    'SDTS'   => 'SD Tiara School',
    'SDTK'   => 'SD Tunas Karya 2',
    'SMP6'   => 'SMPN 6 Jakarta',
    'SMA107' => 'SMAN 107 Jakarta',
    'EPA'    => 'East Park Apartment',
    'RBHIN'  => 'RPTRA Bhineka (EPRA)',
    'ALAC'   => 'Alhuda Academy (EPRA)',
    'PKB'    => 'Pakubuwono (EPRA)',
    'SBSD'   => 'Sekolah Sinarmas BSD',
    'PRV'    => 'Private',
    'TMMLK'  => 'Taman Malaka'
];

// Ekstrak data
$foto   = htmlspecialchars($siswa['foto']);
$nama   = htmlspecialchars($siswa['nama_lengkap']);
$dojang = $dojang_map[$siswa['kode_dojang']] ?? htmlspecialchars($siswa['kode_dojang']);
$nomor  = htmlspecialchars($siswa['nomor_registrasi']);
$ttl    = htmlspecialchars($siswa['tempat_tgl_lahir']);
$qr     = "../generate_qr.php?data=" . urlencode($nomor);

// Proses unggah hasil cropper
if (
    $_SERVER['REQUEST_METHOD'] === 'POST' &&
    isset($_FILES['image']) &&
    isset($_POST['action']) && $_POST['action'] === 'edit_photo'
) {
    $img_data   = file_get_contents($_FILES['image']['tmp_name']);
    $save_path  = '../' . $foto; // path sesuai kolom foto
    if (file_put_contents($save_path, $img_data) !== false) {
        header('Location: idcard.php');
        exit;
    } else {
        $upload_error = 'Gagal menyimpan foto.';
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>ID Card - Momentum Taekwondo Club</title>
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600&display=swap" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.css" />
  <style>
    * { box-sizing: border-box; margin: 0; padding: 0; }
    body {
      font-family: 'Poppins', sans-serif;
      background: #f0f0f0;
      display: flex;
      flex-direction: column;
      align-items: center;
      padding: 100px 20px;
      min-height: 100vh;
    }

    .id-card {
      width: 53.98mm;
      height: 85.6mm;
      background: white;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.25);
      background-image: url('../assets/images/BG_new.png');
      background-size: cover;
      background-position: center;
      display: flex;
      flex-direction: column;
      align-items: center;
      justify-content: flex-start;
      padding: 150px 20px 30px;
      position: relative;
      color: #000;
    }

    .photo-frame {
      width: 100px;
      height: 100px;
      border-radius: 50%;
      overflow: hidden;
      border: 4px solid white;
      background: #ccc;
      position: absolute;
      top: 53px;
      left: 50%;
      transform: translateX(-50%);
    }

    .photo-frame img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      display: block;
    }

    .name { font-size: 11px; font-weight: 600; text-align: center; }
    .dojang {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 6px;
      font-size: 8px;
    }
    .dojang-icon { width: 16px; height: 16px; }

    .details { font-size: 8px; margin-top: 14px; width: 100%; }
    .info-row {
      display: flex;
      align-items: center;
      gap: 4px;
      margin-bottom: 2px;
    }
    .icon { width: 14px; height: 14px; object-fit: contain; flex-shrink: 0; }

    .qr-code {
      width: 70px;
      height: 70px;
      margin: 2px auto 0;
    }
    .qr-code img { width: 100%; height: 100%; }

    .btn {
      margin-top: 20px;
      padding: 10px 20px;
      font-size: 14px;
      background: #007BFF;
      color: white;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      z-index: 10;
    }

    @media print { .btn, #editPhotoBtn { display: none !important; } }

    /* Modal Cropper */
    #cropperModal {
      display: none;
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background: rgba(0,0,0,0.8);
      align-items: center;
      justify-content: center;
      z-index: 100;
    }
    #cropperModal .modal-content {
      background: #fff;
      padding: 20px;
      border-radius: 8px;
      text-align: center;
      max-width: 90%;
    }
    #input-image { margin-top: 10px; }
    #preview {
      display: none;
      width: 200px;
      height: auto;
      margin: 10px auto;
    }
    #saveBtn, #cancelBtn {
      margin: 10px 5px 0;
      padding: 8px 16px;
    }
  </style>
</head>
<body>

<?php if (!empty($upload_error)): ?>
  <script>alert('<?php echo $upload_error; ?>');</script>
<?php endif; ?>

  <!-- Kartu Siswa -->
  <div class="id-card" id="idcard">
    <div class="photo-frame">
      <img src="../<?= $foto ?>?v=<?= time() ?>" alt="Foto Siswa" />
    </div>
    <div class="name"><?= $nama ?></div>
    <div class="dojang">
      <img src="../assets/images/dojang-icon.png" alt="Icon" class="dojang-icon" />
      <?= $dojang ?>
    </div>
    <div class="details">
      <div class="info-row">
        <img src="../assets/images/id-card.png" alt="ID Icon" class="icon" />
        <span><?= $nomor ?></span>
      </div>
      <div class="info-row">
        <img src="../assets/images/calendar.png" alt="Calendar Icon" class="icon" />
        <span><?= $ttl ?></span>
      </div>
    </div>
    <div class="qr-code">
      <img src="<?= $qr ?>" alt="QR Code" />
    </div>
  </div>

  <!-- Tombol aksi -->
  <div style="margin-top: 30px;">
    <button id="editPhotoBtn" class="btn">Edit Foto</button>
    <button class="btn" onclick="printIDCardOnly()">Cetak Kartu</button>
    <button class="btn" onclick="window.location.href='dashboard.php'">Kembali ke Dashboard</button>
  </div>

  <!-- Modal Cropper -->
  <div id="cropperModal">
    <div class="modal-content">
      <h3>Pilih dan Crop Foto</h3>
      <form id="form" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="edit_photo" />
        <input type="file" id="input-image" name="image" accept="image/*" required />
        <img id="preview" src="#" alt="Preview" />
        <br>
        <button id="saveBtn" type="submit" class="btn" style="display:none;">Simpan Foto</button>
        <button type="button" id="cancelBtn" class="btn">Batal</button>
      </form>
    </div>
  </div>

  <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.5.13/cropper.min.js"></script>
  <script>
    function printIDCardOnly() {
      const card = document.getElementById("idcard");
      const win = window.open('', 'PrintWindow', 'width=400,height=600');
      const style = `
        <style>
          * { box-sizing: border-box; margin:0; padding:0; }
          body { font-family:'Poppins',sans-serif; }
          .id-card { width:53.98mm; height:85.6mm; background:white;
            border-radius:12px; background-image:url('../assets/images/BG_new.png');
            background-size:cover; background-position:center;
            display:flex;flex-direction:column;align-items:center;
            justify-content:flex-start;padding:150px 20px 30px;color:#000;
            position:relative; }
          .photo-frame { width:100px;height:100px;border-radius:50%;
            overflow:hidden;border:4px solid white;background:#ccc;
            position:absolute;top:53px;left:50%;transform:translateX(-50%);}          
          .photo-frame img { width:100%;height:100%;object-fit:cover; }
          .name { font-size:11px;font-weight:600;text-align:center; }
          .dojang { display:flex;align-items:center;justify-content:center;
            gap:6px;font-size:8px; }
          .dojang-icon { width:16px;height:16px; }
          .details { font-size:8px;margin-top:14px;width:100%; }
          .info-row { display:flex;align-items:center;gap:4px;margin-bottom:2px; }
          .icon { width:14px;height:14px;object-fit:contain;flex-shrink:0; }
          .qr-code { width:70px;height:70px;margin:0 auto; }
          .qr-code img { width:100%;height:100%; }
          @page { size:53.98mm 85.6mm;margin:0; }
          @media print { body{-webkit-print-color-adjust:exact!important;print-color-adjust:exact!important;} }
        </style>`;
      win.document.write(`
        <html>
          <head>
            <title>Print ID Card</title>
            <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@600&display=swap" rel="stylesheet" />
            ${style}
          </head>
          <body onload="window.print(); window.close();">
            ${card.outerHTML}
          </body>
        </html>`);
      win.document.close();
    }

    // Cropper logic
    const editBtn   = document.getElementById('editPhotoBtn');
    const modal     = document.getElementById('cropperModal');
    const cancelBtn = document.getElementById('cancelBtn');
    const inputImg  = document.getElementById('input-image');
    const preview   = document.getElementById('preview');
    const saveBtn   = document.getElementById('saveBtn');
    const form      = document.getElementById('form');
    let cropper;

    editBtn.addEventListener('click', () => modal.style.display = 'flex');
    cancelBtn.addEventListener('click', () => {
      modal.style.display = 'none';
      if (cropper) cropper.destroy();
      preview.style.display = 'none';
      saveBtn.style.display = 'none';
      inputImg.value = '';
    });

    inputImg.addEventListener('change', e => {
      const file = e.target.files[0]; if (!file) return;
      const url = URL.createObjectURL(file);
      preview.src = url; preview.style.display = 'block';
      if (cropper) cropper.destroy();
      cropper = new Cropper(preview, { aspectRatio:1, viewMode:1 });
      saveBtn.style.display = 'inline-block';
    });

    form.addEventListener('submit', e => {
      e.preventDefault(); if (!cropper) return;
      cropper.getCroppedCanvas({ width:300, height:300 }).toBlob(blob => {
        const fd = new FormData(form);
        fd.set('image', blob, 'foto.jpg');
        fetch('', { method:'POST', body:fd })
          .then(() => location.reload())
          .catch(() => alert('Gagal mengirim gambar.'));
      }, 'image/jpeg');
    });
  </script>

</body>
</html>
