<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

include '../db.php';

$nomor = $_SESSION['nomor_registrasi'] ?? '';
if (!$nomor) {
    die('Nomor registrasi siswa tidak ditemukan di sesi.');
}

$tahun_selected = $_GET['tahun'] ?? date('Y');

$stmtSiswa = $pdo->prepare("SELECT * FROM siswa WHERE nomor_registrasi = ?");
$stmtSiswa->execute([$nomor]);
$siswa = $stmtSiswa->fetch(PDO::FETCH_ASSOC);
if (!$siswa) {
    die('Data siswa tidak ditemukan.');
}

$dojang_map = [
    'BWPK' => 'Balai Warga Pondok Kelapa',
    'SDTS' => 'SD Tiara School',
    'SDTK' => 'SD Tunas Karya 2',
    'SMP6' => 'SMPN 6 Jakarta',
    'SMA107' => 'SMAN 107 Jakarta',
    'EPA' => 'East Park Apartment',
    'RBHIN' => 'RPTRA Bhineka (EPRA)',
    'ALAC' => 'Alhuda Academy (EPRA)',
    'PKB' => 'Pakubuwono (EPRA)',
    'SBSD' => 'Sekolah Sinarmas BSD',
    'PRV' => 'Private',
    'TMMLK' => 'Taman Malaka'
];

$nama_bulan = [
    1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
    'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
];

$stmt = $pdo->prepare("SELECT bulan, tahun, status, tipe_pembayaran, waktu_bayar FROM iuran WHERE nomor_registrasi = ? AND tahun = ? ORDER BY bulan ASC");
$stmt->execute([$nomor, $tahun_selected]);
$iuran_data_raw = $stmt->fetchAll(PDO::FETCH_ASSOC);

$iuran_data = [];
foreach ($iuran_data_raw as $row) {
    $iuran_data[(int)$row['bulan']] = $row;
}

$current_year = date('Y');
$year_start = 2024;
$years = range($year_start, $current_year);

function statusLabel($status) {
    switch (strtolower($status)) {
        case 'lunas': return '<span style="color:green; font-weight:bold;">Lunas</span>';
        case 'pending': return '<span style="color:orange; font-weight:bold;">Pending</span>';
        case 'verifikasi': return '<span style="color:blue; font-weight:bold;">Verifikasi</span>';
        default: return '<span style="color:red; font-weight:bold;">Belum Bayar</span>';
    }
}

function formatSabukImgName($sabukName) {
    $str = strtolower(trim($sabukName));
    $str = str_replace([' ', '-'], '_', $str);
    return $str;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Status Iuran Siswa Tahun <?= htmlspecialchars($tahun_selected) ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 30px auto;
            max-width: 900px;
        }

        h1 {
            text-align: center;
        }

        .foto-siswa {
            position: absolute;
            top: 20px;
            left: 20px;
            width: 120px;
            height: 140px;
            text-align: center;
            border: 1px solid #000;
            padding: 5px;
            background: #fff;
        }

        .foto-siswa img {
            width: 100%;
            height: 100px;
            object-fit: contain;
            background: #f0f0f0;
        }

        .foto-siswa .sabuk-img {
            width: 80px;
            height: auto;
            border: 1px solid #000;
            border-radius: 5px;
        }

        .main-content {
            margin-left: 160px;
            padding-top: 10px;
        }

        .info-siswa p {
            margin: 2px 0;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 20px;
            font-size: 13px;
        }

        th, td {
            border: 1px solid #000;
            padding: 6px 8px;
            text-align: center;
        }

        th {
            background-color: #eee;
        }

        .btn-group {
            margin-top: 20px;
        }

        .btn-group button,
        .btn-group a {
            display: inline-block;
            margin-right: 10px;
            padding: 8px 12px;
            font-size: 14px;
            font-weight: bold;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            text-decoration: none;
        }

        .btn-group button {
            background-color: #007bff;
            color: #fff;
        }

        .btn-group button:hover {
            background-color: #0056b3;
        }

        .btn-group a {
            background-color: #6c757d;
            color: #fff;
        }

       @media print {
    .btn-group,
    form {
        display: none !important;
    }

    .foto-siswa {
        position: relative;
        top: 0;
        left: 0;
        float: left;
        margin-right: 20px;
        width: 120px;
    }

    .main-content {
        margin-left: 0 !important;
    }
}

    </style>
</head>
<body>

<h1>Status Iuran Siswa Tahun <?= htmlspecialchars($tahun_selected) ?></h1>

<div class="foto-siswa">
    <?php
    $foto_path = '../uploads/foto/' . $siswa['nomor_registrasi'] . '.jpg';
    if (file_exists($foto_path)) {
        echo '<img src="' . htmlspecialchars($foto_path) . '" alt="Foto Siswa">';
    } else {
        echo '<div style="width:100%; height:100px; display:flex; justify-content:center; align-items:center; font-size:12px; color:#666;">No Photo</div>';
    }

    $sabuk_file = '../sabuk/' . formatSabukImgName($siswa['sabuk'] ?? 'putih') . '.png';
    if (file_exists($sabuk_file)) {
        echo '<img class="sabuk-img" src="' . htmlspecialchars($sabuk_file) . '" alt="Sabuk">';
    } else {
        echo '<div style="font-size:12px; color:#666;">Sabuk: ' . htmlspecialchars($siswa['sabuk'] ?? 'Putih') . '</div>';
    }
    ?>
</div>

<div class="main-content">
    <div class="info-siswa">
        <p><strong>Nama Lengkap:</strong> <?= htmlspecialchars($siswa['nama_lengkap']) ?></p>
        <p><strong>Nomor Registrasi:</strong> <?= htmlspecialchars($siswa['nomor_registrasi']) ?></p>
        <p><strong>Dojang:</strong> <?= htmlspecialchars($dojang_map[$siswa['kode_dojang']] ?? '-') ?></p>
        <p><strong>No. HP:</strong> <?= htmlspecialchars($siswa['no_hp']) ?></p>
        <p><strong>Email:</strong> <?= htmlspecialchars($siswa['email']) ?></p>
    </div>

    <form method="GET" action="">
        <label for="tahun">Pilih Tahun: </label>
        <select id="tahun" name="tahun" onchange="this.form.submit()">
            <?php foreach ($years as $y): ?>
                <option value="<?= $y ?>" <?= $y == $tahun_selected ? 'selected' : '' ?>><?= $y ?></option>
            <?php endforeach; ?>
        </select>
        <noscript><input type="submit" value="Tampilkan"></noscript>
    </form>

    <div class="btn-group">
        <button onclick="window.print()">Cetak Laporan</button>
        <a href="../siswa/dashboard.php">Kembali ke Dashboard</a>
    </div>

    <table>
        <thead>
        <tr>
            <th>Bulan</th>
            <th>Status</th>
            <th>Tipe Pembayaran</th>
            <th>Tanggal Bayar</th>
        </tr>
        </thead>
        <tbody>
        <?php for ($b = 1; $b <= 12; $b++):
            $iuran = $iuran_data[$b] ?? null;
            $status = $iuran['status'] ?? '';
            $tipe = $iuran['tipe_pembayaran'] ?? '-';
            $tgl_bayar = '-';
            if (!empty($iuran['waktu_bayar']) && $iuran['waktu_bayar'] != '0000-00-00 00:00:00') {
                $tgl_bayar = date('d-m-Y', strtotime($iuran['waktu_bayar']));
            }
        ?>
            <tr>
                <td style="text-align:left; padding-left:12px;"><?= $nama_bulan[$b] ?></td>
                <td><?= statusLabel($status) ?></td>
                <td><?= htmlspecialchars(ucfirst($tipe)) ?></td>
                <td><?= $tgl_bayar ?></td>
            </tr>
        <?php endfor; ?>
        </tbody>
    </table>
</div>

</body>
</html>
