<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include '../db.php';

// Cek session siswa
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

$nomor = $_SESSION['nomor_registrasi'] ?? '';
if (!$nomor) {
    die('Nomor registrasi tidak ditemukan di session.');
}

// Handle update data via POST
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['aksi']) && $_POST['aksi'] === 'update_siswa') {
    $nomor_post = $_POST['nomor_registrasi'] ?? '';
    $nomor_sertifikat = $_POST['nomor_sertifikat'] ?? null;
    $sabuk = $_POST['sabuk'] ?? null;

    if (!$nomor_post) {
        echo json_encode(['status' => 'error', 'message' => 'Nomor registrasi diperlukan']);
        exit;
    }

    $fieldsToUpdate = [];
    $params = [];

    if ($nomor_sertifikat !== null) {
        $fieldsToUpdate[] = "nomor_sertifikat = ?";
        $params[] = $nomor_sertifikat;
    }
    if ($sabuk !== null) {
        $fieldsToUpdate[] = "sabuk = ?";
        $params[] = $sabuk;
    }

    if (empty($fieldsToUpdate)) {
        echo json_encode(['status' => 'error', 'message' => 'Tidak ada data untuk diupdate']);
        exit;
    }

    $params[] = $nomor_post;

    $sql = "UPDATE siswa SET " . implode(', ', $fieldsToUpdate) . " WHERE nomor_registrasi = ?";
    $stmt = $pdo->prepare($sql);

    if ($stmt->execute($params)) {
        echo json_encode(['status' => 'success', 'message' => 'Data berhasil diperbarui']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Gagal memperbarui data']);
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<title>MOMENTUM TAEKWONDO CLUB - Data Siswa</title>
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
<style>
body {
    font-family: 'Roboto', sans-serif;
    background: #f4f6f8;
    margin: 0 auto;
    padding: 20px;
    max-width: 800px;
    color: #333;
}
h1 {
    text-align: center;
    background: linear-gradient(to right, #007BFF, #00C6FF);
    color: white;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
    margin-bottom: 30px;
}
#info-siswa {
    background: #fff;
    border-radius: 10px;
    padding: 25px;
    margin-top: 30px;
    box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
}
#foto-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
    margin-bottom: 20px;
}
#img-siswa {
    width: 120px;
    height: 140px;
    object-fit: cover;
    border: 2px solid #007BFF;
    background: #f0f0f0;
    border-radius: 8px;
    transition: transform 0.3s ease;
}
#img-siswa:hover {
    transform: scale(1.05);
}
#img-sabuk {
    max-width: 120px;
    height: auto;
    border: 2px solid #007BFF;
    border-radius: 6px;
}
label {
    display: block;
    margin-top: 15px;
    font-weight: 700;
    color: #007BFF;
}
select,
input[type="text"],
input[type="file"],
textarea,
input[type="date"] {
    width: 100%;
    padding: 10px;
    margin-top: 5px;
    box-sizing: border-box;
    border-radius: 6px;
    border: 1px solid #ccc;
    font-size: 15px;
    transition: border 0.3s;
}
select:focus,
input[type="text"]:focus,
input[type="file"]:focus,
textarea:focus,
input[type="date"]:focus {
    border-color: #007BFF;
    outline: none;
}
button {
    background: #007BFF;
    color: white;
    border: none;
    padding: 12px 20px;
    border-radius: 6px;
    font-size: 16px;
    margin-top: 20px;
    margin-right: 10px;
    cursor: pointer;
    transition: background 0.3s ease;
}
button:hover,
button:focus {
    background: #0056b3;
    outline: none;
}
table {
    border-collapse: collapse;
    width: 100%;
    margin-top: 20px;
    font-size: 14px;
    background: #fff;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 3px 12px rgba(0, 0, 0, 0.05);
}
th, td {
    border: 1px solid #eee;
    padding: 10px;
    text-align: center;
    vertical-align: middle;
}
th {
    background: #007BFF;
    color: white;
    font-weight: 600;
}
#tabel-absensi img {
    max-height: 30px;
    max-width: 50px;
}
#list-prestasi ul {
    list-style-type: disc;
    padding-left: 20px;
}
#list-prestasi li {
    margin-bottom: 8px;
    text-align: left;
}
</style>
</head>
<body>
<div style="margin-bottom: 20px;">
  <a href="/siswa/dashboard.php" 
     style="display: inline-block; padding: 10px 20px; background: #007BFF; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; transition: background-color 0.3s ease;">
    &larr; Kembali ke Dashboard
  </a>
</div>
    
<h1>MOMENTUM TAEKWONDO CLUB</h1>

<div id="info-siswa" tabindex="0" aria-live="polite" aria-atomic="true">
    <div id="foto-container">
        <img src="" alt="Foto Siswa" id="img-siswa">
        <img src="" alt="Gambar Sabuk" id="img-sabuk">
    </div>

    <h2 id="nama-siswa"></h2>
    <p><strong>Nomor Registrasi:</strong> <span id="nomor-siswa"></span></p>
    <p><strong>Dojang:</strong> <span id="dojang-siswa"></span></p>
    <p><strong>Alamat:</strong> <span id="alamat-siswa"></span></p>
    <p><strong>No HP:</strong> <span id="nohp-siswa"></span></p>
    <p><strong>Tanggal Lahir:</strong> <span id="ttl-siswa"></span></p>
    <p><strong>Nomor Sertifikat:</strong> <span id="nomor-sertifikat-siswa"></span></p>
    <label for="input-sertifikat">Update Nomor Sertifikat</label>
    <input type="text" id="input-sertifikat" placeholder="Masukkan nomor sertifikat" aria-label="Update nomor sertifikat">

    <label for="select-sabuk">Update Sabuk</label>
    <select id="select-sabuk" aria-label="Update sabuk">
        <option value="Putih">Putih</option>
        <option value="Kuning">Kuning</option>
        <option value="Kuning Strip Hijau">Kuning Strip Hijau</option>
        <option value="Hijau">Hijau</option>
        <option value="Hijau Strip Biru">Hijau Strip Biru</option>
        <option value="Biru">Biru</option>
        <option value="Biru Strip Merah">Biru Strip Merah</option>
        <option value="Merah">Merah</option>
        <option value="Merah Strip 1">Merah Strip 1</option>
        <option value="Merah Strip 2">Merah Strip 2</option>
    </select>
    
    <button id="btn-update" tabindex="0">Update Data</button>

<h3>Laporan Absensi</h3>
<div style="overflow-x:auto;">
  <table id="tabel-absensi" style="width:100%; border-collapse: collapse;">
    <thead>
      <tr>
        <th>Bulan</th>
        <th>I</th><th>II</th><th>III</th><th>IV</th>
        <th>V</th><th>VI</th><th>VII</th><th>VIII</th>
      </tr>
    </thead>
    <tbody>
      <!-- Data absensi akan di-inject JS di sini -->
    </tbody>
  </table>
</div>

<h3>Status Iuran 1 Tahun Terakhir</h3>
    <table>
        <thead>
            <tr>
                <th>Bulan</th>
                <th>Tahun</th>
                <th>Status</th>
                <th>Tipe Pembayaran</th>
            </tr>
        </thead>
        <tbody id="tabel-iuran"></tbody>
    </table>
    
    
    <!-- Upload Dokumen Geup -->
    <h3>Upload Sertifikat Geup</h3>
    <form id="form-upload" enctype="multipart/form-data">
        <label for="jenis-dokumen">Pilih Tingkat Geup</label>
        <select id="jenis-dokumen" name="jenis" aria-label="Pilih tingkat geup">
            <option value="">-- Pilih Tingkatan --</option>
            <option value="Geup IX">Geup IX (Kuning)</option>
            <option value="Geup VIII">Geup VIII (Kuning Strip)</option>
            <option value="Geup VII">Geup VII (Hijau)</option>
            <option value="Geup VI">Geup VI (Hijau Strip)</option>
            <option value="Geup V">Geup V (Biru)</option>
            <option value="Geup IV">Geup IV (Biru Strip)</option>
            <option value="Geup III">Geup III (Merah)</option>
            <option value="Geup II">Geup II (Merah Strip I)</option>
            <option value="Geup I">Geup I (Merah Strip II)</option>
        </select>

        <label for="file-dokumen">Pilih File Dokumen (.pdf/.jpg/.png)</label>
        <input type="file" id="file-dokumen" name="file" accept=".pdf,.jpg,.jpeg,.png" aria-label="Pilih file dokumen">

        <button type="submit" tabindex="0">Upload Dokumen</button>
    </form>

    <!-- Tabel Dokumen -->
    <h3>Dokumen Siswa</h3>
    <div id="dokumen-siswa">
        <table style="width:100%; margin-top:10px;">
            <thead>
                <tr>
                    <th>Jenis Dokumen</th>
                    <th>Nama File</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody id="tabel-dokumen"></tbody>
        </table>
    </div>
</div>

<!-- Prestasi Container (default hidden) -->
<div id="prestasi-container" style="display:none;">
  <h3>Prestasi</h3>
  <div id="list-prestasi" style="margin-bottom: 30px;"></div>

  <h4>Tambah Prestasi Baru</h4>
  <form id="form-prestasi" style="max-width: 500px;">
    <input type="text" id="prestasi-judul" placeholder="Nama Kejuaraan" required style="width: 100%; padding: 8px; margin-bottom: 8px;">
    
   <label for="prestasi-juara-ke">Juara ke:</label>
<select id="prestasi-juara-ke" name="juara_ke" style="width:100%; padding:8px; margin-bottom:8px;">
  <option value="">-- Pilih Juara Ke --</option>
  <option value="1">Juara 1</option>
  <option value="2">Juara 2</option>
  <option value="3">Juara 3</option>
</select>

    <textarea id="prestasi-deskripsi" placeholder="Keterangan (opsional, boleh dikosongkan)" style="width: 100%; padding: 8px; margin-bottom: 8px;"></textarea>
    <input type="date" id="prestasi-tanggal" required style="width: 100%; padding: 8px; margin-bottom: 12px;">
    <button type="submit" style="padding: 12px 20px; background:#007BFF; color:#fff; border:none; border-radius: 6px; cursor:pointer;">Tambah Prestasi</button>
  </form>
</div>

<script>
const dojangMap = {
    'BWPK': 'Balai Warga Pondok Kelapa',
    'SDTS': 'SD Tiara School',
    'SDTK': 'SD Tunas Karya 2',
    'SMP6': 'SMPN 6 Jakarta',
    'SMA107': 'SMAN 107 Jakarta',
    'EPA': 'East Park Apartment',
    'RBHIN': 'RPTRA Bhineka (EPRA)',
    'ALAC': 'Alhuda Academy (EPRA)',
    'PKB': 'Pakubuwono (EPRA)',
    'SBSD': 'Sekolah Sinarmas BSD',
    'PRV': 'Private',
    'TMMLK': 'Taman Malaka'
};

const namaBulan = ['', 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
                   'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];

function loadSiswaData(nomor) {
    fetch(`/get_data_siswa.php?nomor=${encodeURIComponent(nomor)}`)
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                const s = data.siswa;
                const iuran = data.iuran || [];
                const prestasi = data.prestasi || [];

                document.getElementById('img-siswa').src = `../uploads/foto/${s.nomor_registrasi}.jpg`;
                const sabukFile = (s.sabuk || 'putih').toLowerCase().replace(/[\s-]/g, '_');
                document.getElementById('img-sabuk').src = `../sabuk/${sabukFile}.png`;
                document.getElementById('nama-siswa').textContent = s.nama_lengkap;
                document.getElementById('nomor-siswa').textContent = s.nomor_registrasi;
                document.getElementById('dojang-siswa').textContent = dojangMap[s.kode_dojang] || s.kode_dojang;
                document.getElementById('alamat-siswa').textContent = s.alamat_lengkap;
                document.getElementById('nohp-siswa').textContent = s.no_hp;
                document.getElementById('ttl-siswa').textContent = s.tempat_tgl_lahir;
                document.getElementById('nomor-sertifikat-siswa').textContent = s.nomor_sertifikat || '';
                document.getElementById('tabel-iuran').innerHTML = '';
                document.getElementById('input-sertifikat').value = s.nomor_sertifikat || '';
                document.getElementById('select-sabuk').value = s.sabuk || 'Putih';

                const tbodyIuran = document.getElementById('tabel-iuran');
                tbodyIuran.innerHTML = '';
                if (iuran.length === 0) {
                    tbodyIuran.innerHTML = '<tr><td colspan="4">Tidak ada data iuran</td></tr>';
                } else {
                    iuran.forEach(row => {
                        const tr = document.createElement('tr');
                        tr.innerHTML = `
                            <td>${row.bulan}</td>
                            <td>${row.tahun}</td>
                            <td>${row.status}</td>
                            <td>${row.tipe_pembayaran}</td>
                        `;
                        tbodyIuran.appendChild(tr);
                    });
                }
                
                renderAbsensi(data.absensi || []);
                renderDokumen(s.nomor_registrasi);

                renderPrestasi(prestasi);
                document.getElementById('prestasi-container').style.display = 'block'; // Tampilkan prestasi
                document.getElementById('info-siswa').style.display = 'block';
            } else {
                alert(data.message || 'Gagal ambil data siswa');
            }
        });
}

function renderAbsensi(absensiData) {
    const tbody = document.querySelector('#tabel-absensi tbody');
    tbody.innerHTML = '';
    const abs = {};
    for (let b = 1; b <= 12; b++) {
        abs[b] = {};
        for (let p = 1; p <= 8; p++) {
            abs[b][p] = '';
        }
    }

    absensiData.forEach(item => {
        const bulan = parseInt(item.bulan);
        const pertemuan = parseInt(item.pertemuan);
        if (abs[bulan] && abs[bulan][pertemuan] !== undefined) {
            abs[bulan][pertemuan] = item.paraf_pelatih;
        }
    });

    for (let b = 1; b <= 12; b++) {
        const tr = document.createElement('tr');
        let html = `<td>${namaBulan[b]}</td>`;
        for (let p = 1; p <= 8; p++) {
            const paraf = abs[b][p];
            html += paraf
                ? `<td><img src="/paraf/${paraf}.png" alt="Paraf" style="max-height:30px;" onerror="this.style.display='none'"></td>`
                : `<td>-</td>`;
        }
        tr.innerHTML = html;
        tbody.appendChild(tr);
    }
}

function renderDokumen(nomor) {
    fetch(`/get_dokumen.php?nomor=${encodeURIComponent(nomor)}`)
        .then(res => res.json())
        .then(data => {
            const tbody = document.getElementById('tabel-dokumen');
            tbody.innerHTML = '';
            if (data.status === 'success') {
                if (data.files.length === 0) {
                    tbody.innerHTML = '<tr><td colspan="3">Tidak ada dokumen.</td></tr>';
                } else {
                    data.files.forEach(doc => {
                        const tr = document.createElement('tr');
                        tr.innerHTML = `
                            <td>${doc.jenis}</td>
                            <td>${doc.nama}</td>
                            <td>
                                <a href="/uploads/dokumen/${nomor}/${doc.nama}" target="_blank">Preview</a> |
                                <a href="/uploads/dokumen/${nomor}/${doc.nama}" download>Download</a>
                            </td>`;
                        tbody.appendChild(tr);
                    });
                }
            }
        });
}

function renderPrestasi(prestasiList) {
  const container = document.getElementById('list-prestasi');
  container.innerHTML = '';

  if (!prestasiList || prestasiList.length === 0) {
    container.innerHTML = '<p>Tidak ada prestasi.</p>';
    return;
  }

  let html = '<ul>';
  prestasiList.forEach(p => {
    const tanggal = new Date(p.tanggal).toLocaleDateString('id-ID', {
      day: '2-digit', month: 'long', year: 'numeric'
    });

    const juaraText = p.juara_ke ? `Juara ${p.juara_ke} - ` : '';
    const deskripsiText = p.deskripsi && p.deskripsi.trim() !== '' ? p.deskripsi : '-';

    html += `<li><strong>${juaraText}${p.judul}</strong> (${tanggal})<br>${deskripsiText}</li>`;
  });
  html += '</ul>';

  container.innerHTML = html;
}

document.getElementById('btn-update').addEventListener('click', () => {
    const nomor = document.getElementById('nomor-siswa').textContent.trim();
    const nomorSertifikat = document.getElementById('input-sertifikat').value.trim();
    const sabuk = document.getElementById('select-sabuk').value;
    if (!nomor) return alert('Data siswa belum dimuat!');
    fetch(window.location.href, {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: new URLSearchParams({
            aksi: 'update_siswa',
            nomor_registrasi: nomor,
            nomor_sertifikat: nomorSertifikat,
            sabuk: sabuk
        })
    })
    .then(res => res.json())
    .then(data => {
        alert(data.message);
        if (data.status === 'success') loadSiswaData(nomor);
    });
});

// Upload Dokumen
document.getElementById('form-upload').addEventListener('submit', e => {
    e.preventDefault();
    const nomor = document.getElementById('nomor-siswa').textContent.trim();
    const jenis = document.getElementById('jenis-dokumen').value;
    const fileInput = document.getElementById('file-dokumen');
    if (!nomor || !jenis || fileInput.files.length === 0) {
        return alert('Lengkapi data dan pilih file!');
    }
    const formData = new FormData();
    formData.append('nomor', nomor);
    formData.append('jenis', jenis);
    formData.append('file', fileInput.files[0]);

    fetch('/upload_dokumen.php', {
        method: 'POST',
        body: formData
    })
    .then(res => res.json())
    .then(data => {
        alert(data.message);
        if (data.status === 'success') {
            renderDokumen(nomor);
            fileInput.value = '';
        }
    });
});

// Tambah Prestasi Baru
document.getElementById('form-prestasi').addEventListener('submit', e => {
  e.preventDefault();

  const nomor = document.getElementById('nomor-siswa').textContent.trim();
  const judul = document.getElementById('prestasi-judul').value.trim();
  const juaraKe = document.getElementById('prestasi-juara-ke').value.trim();
  const deskripsi = document.getElementById('prestasi-deskripsi').value.trim();
  const tanggal = document.getElementById('prestasi-tanggal').value;

  if (!nomor || !judul || !tanggal) {
    alert('Lengkapi data prestasi!');
    return;
  }

  fetch('/add_prestasi.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: new URLSearchParams({
      nomor_registrasi: nomor,
      judul: judul,
      juara_ke: juaraKe,
      deskripsi: deskripsi,
      tanggal: tanggal
    })
  })
  .then(res => res.json())
  .then(data => {
    alert(data.message);
    if (data.status === 'success') {
      e.target.reset();
      loadSiswaData(nomor);
    }
  });
});

// Muat data otomatis pakai session nomor registrasi
document.addEventListener('DOMContentLoaded', () => {
    loadSiswaData('<?= $nomor ?>');
});
</script>
</body>
</html>
