<?php
session_start();
include '../db.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

$nomor = $_SESSION['nomor_registrasi'] ?? '';
if (!$nomor) {
    die(json_encode(['status' => 'error', 'message' => 'Nomor registrasi tidak ditemukan di session.']));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $judul = $_POST['judul'] ?? '';
    $juara_ke = $_POST['juara_ke'] ?? null;
    $deskripsi = $_POST['deskripsi'] ?? null;
    $tanggal = $_POST['tanggal'] ?? null;
    $gambar = null;

    if (isset($_FILES['gambar']) && $_FILES['gambar']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['gambar']['name'], PATHINFO_EXTENSION);
        $namaBaru = 'prestasi_' . time() . '.' . $ext;
        $tujuan = '../uploads/' . $namaBaru;
        move_uploaded_file($_FILES['gambar']['tmp_name'], $tujuan);
        $gambar = 'uploads/' . $namaBaru;
    }

    $stmt = $pdo->prepare("INSERT INTO prestasi (nomor_registrasi, judul, juara_ke, deskripsi, tanggal, gambar) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->execute([$nomor, $judul, $juara_ke, $deskripsi, $tanggal, $gambar]);

    echo json_encode(['status' => 'success']);
    exit;
}

$stmt = $pdo->prepare("SELECT kode_dojang, nama_lengkap, alamat_lengkap, tempat_tgl_lahir, sabuk, foto FROM siswa WHERE nomor_registrasi = ?");
$stmt->execute([$nomor]);
$siswa = $stmt->fetch(PDO::FETCH_ASSOC);

$stmt2 = $pdo->prepare("SELECT * FROM prestasi WHERE nomor_registrasi = ? ORDER BY tanggal DESC");
$stmt2->execute([$nomor]);
$prestasi = $stmt2->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Prestasi Siswa</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<div style="margin-bottom: 20px;">
  <a href="/siswa/dashboard.php" 
     style="display: inline-block; padding: 10px 20px; background: #007BFF; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; transition: background-color 0.3s ease;">
    &larr; Kembali ke Dashboard
  </a>
</div>
<body class="bg-gray-100 p-6">
<div class="max-w-4xl mx-auto">
  <h1 class="text-2xl font-bold mb-4">Data Siswa</h1>
  <div class="bg-white p-4 rounded shadow mb-6">
    <div class="flex items-start space-x-4">
      <?php if ($siswa['foto']): ?>
        <img src="../<?= htmlspecialchars($siswa['foto']) ?>" alt="Foto" class="w-32 h-32 rounded object-cover border">
      <?php endif; ?>
      <div>
        <p><strong>Nama:</strong> <?= htmlspecialchars($siswa['nama_lengkap']) ?></p>
        <p><strong>Dojang:</strong> <?= htmlspecialchars($siswa['kode_dojang']) ?></p>
        <p><strong>Alamat:</strong> <?= htmlspecialchars($siswa['alamat_lengkap']) ?></p>
        <p><strong>TTL:</strong> <?= htmlspecialchars($siswa['tempat_tgl_lahir']) ?></p>
        <p><strong>Sabuk:</strong> <?= htmlspecialchars($siswa['sabuk']) ?></p>
        <?php if ($siswa['sabuk']): ?>
           <img src="/sabuk/<?= strtolower(str_replace(' ', '_', $siswa['sabuk'])) ?>.png" alt="Gambar Sabuk" class="mt-2 h-6">
        <?php endif; ?>
      </div>
    </div>
  </div>

  <h2 class="text-xl font-semibold mb-2">Daftar Prestasi</h2>
  <table class="table-auto w-full bg-white rounded shadow overflow-hidden mb-6">
    <thead>
      <tr class="bg-gray-200">
        <th class="px-4 py-2 text-left">Nama Kejuaraan</th>
        <th class="px-4 py-2 text-left">Juara</th>
        <th class="px-4 py-2 text-left">Deskripsi</th>
        <th class="px-4 py-2 text-left">Tanggal Kejuaraan</th>
        <th class="px-4 py-2 text-left">Foto</th>
      </tr>
    </thead>
    <tbody>
    <?php foreach ($prestasi as $p): ?>
      <tr>
        <td class="px-4 py-2"><?= htmlspecialchars($p['judul']) ?></td>
        <td class="px-4 py-2"><?= $p['juara_ke'] ?? '-' ?></td>
        <td class="px-4 py-2"><?= htmlspecialchars($p['deskripsi'] ?? '-') ?></td>
        <td class="px-4 py-2"><?= $p['tanggal'] ?></td>
        <td class="px-4 py-2">
          <?php if ($p['gambar']): ?>
            <img src="../<?= $p['gambar'] ?>" class="h-16">
          <?php else: ?>
            -
          <?php endif; ?>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>

  <h2 class="text-xl font-semibold mb-2">Tambah Prestasi</h2>
  <form id="form-prestasi" class="bg-white p-6 rounded shadow space-y-4" enctype="multipart/form-data" method="POST">
    <div>
      <label class="block mb-1 font-medium">Nama Kejuaraan</label>
      <input type="text" name="judul" required class="w-full border rounded px-3 py-2">
    </div>
    <div>
      <label class="block mb-1 font-medium">Juara Ke</label>
      <select name="juara_ke" class="w-full border rounded px-3 py-2">
        <option value="1">Juara 1</option>
        <option value="2">Juara 2</option>
        <option value="3">Juara 3</option>
        <option value="4">Juara 4</option>
      </select>
    </div>
    <div>
      <label class="block mb-1 font-medium">Deskripsi</label>
      <textarea name="deskripsi" rows="3" class="w-full border rounded px-3 py-2"></textarea>
    </div>
    <div>
      <label class="block mb-1 font-medium">Tanggal Kejuaraan</label>
      <input type="date" name="tanggal" class="w-full border rounded px-3 py-2">
    </div>
    <div>
      <label class="block mb-1 font-medium">Foto</label>
      <input type="file" name="gambar" class="w-full">
    </div>
    <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Simpan</button>
  </form>
</div>
</body>
</html>
