<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'siswa') {
    header('Location: ../login.php');
    exit;
}

include '../db.php';

function formatTanggalLahir($tempat_tgl) {
    $parts = explode(',', $tempat_tgl);
    if (count($parts) != 2) return $tempat_tgl;
    $tempat = trim($parts[0]);
    $tgl = trim($parts[1]);

    $dateObj = DateTime::createFromFormat('d-m-Y', $tgl);
    if (!$dateObj) return $tempat_tgl;

    $bulanIndo = [
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    ];
    return $tempat . ', ' . $dateObj->format('d') . ' ' . $bulanIndo[(int)$dateObj->format('m')] . ' ' . $dateObj->format('Y');
}

function formatSabukImgName($sabukName) {
    $str = strtolower($sabukName);
    return str_replace([' ', '-'], '_', $str);
}

$nomor = $_SESSION['nomor_registrasi'] ?? ($_GET['nomor'] ?? '');
if (!$nomor) die('Nomor registrasi siswa belum diberikan.');

$tahun_selected = $_GET['tahun'] ?? date('Y');

$stmt = $pdo->prepare("SELECT * FROM siswa WHERE nomor_registrasi = ?");
$stmt->execute([$nomor]);
$siswa = $stmt->fetch();
if (!$siswa) die('Data siswa tidak ditemukan.');

$dojang_map = [
    'BWPK' => 'Balai Warga Pondok Kelapa',
    'SDTS' => 'SD Tiara School',
    'SDTK' => 'SD Tunas Karya 2',
    'SMP6' => 'SMPN 6 Jakarta',
    'SMA107' => 'SMAN 107 Jakarta',
    'EPA' => 'East Park Apartment',
    'RBHIN' => 'RPTRA Bhineka (EPRA)',
    'ALAC' => 'Alhuda Academy (EPRA)',
    'PKB' => 'Pakubuwono (EPRA)',
    'SBSD' => 'Sekolah Sinarmas BSD',
    'PRV' => 'Private',
    'TMMLK' => 'Taman Malaka'
];

$ttl_formatted = formatTanggalLahir($siswa['tempat_tgl_lahir']);
$nomor_sertifikat = $siswa['nomor_sertifikat'] ?? '-';

$stmt = $pdo->prepare("SELECT bulan, pertemuan, paraf_pelatih FROM absensi WHERE nomor_registrasi = ? AND tahun = ?");
$stmt->execute([$nomor, $tahun_selected]);
$absensi_raw = $stmt->fetchAll(PDO::FETCH_ASSOC);

$absensi = [];
for ($b = 1; $b <= 12; $b++) {
    for ($p = 1; $p <= 8; $p++) {
        $absensi[$b][$p] = '';
    }
}

foreach ($absensi_raw as $row) {
    $bulan = (int)$row['bulan'];
    $pertemuan = (int)$row['pertemuan'];
    if ($pertemuan >= 1 && $pertemuan <= 8) {
        $absensi[$bulan][$pertemuan] = $row['paraf_pelatih'];
    }
}

$nama_bulan = [
    1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
    'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
];
$angka_romawi = ['I', 'II', 'III', 'IV', 'V', 'VI', 'VII', 'VIII'];

$current_year = date('Y');
$year_start = 2024;
$years = range($year_start, $current_year);
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<title>Laporan Absensi Tahun <?= htmlspecialchars($tahun_selected) ?> - <?= htmlspecialchars($siswa['nama_lengkap']) ?></title>
<style>
    body {
        font-family: Arial, sans-serif;
        margin: 30px;
        max-width: 900px;
        margin-left: auto;
        margin-right: auto;
    }
    h2, h3 {
        text-align: center;
        margin-bottom: 0;
    }
    .foto-siswa {
        position: absolute;
        top: 20px;
        left: 20px;
        width: 120px;
        height: 140px;
        border: 1px solid #000;
        padding: 5px;
        background: #fff;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }
    .foto-siswa img {
        width: 100%;
        height: 100px;
        object-fit: contain;
        background: #f0f0f0;
    }
    .foto-siswa .sabuk-img {
        width: 80px;
        height: auto;
        border: 1px solid #000;
        border-radius: 5px;
    }
    .logo-club {
        position: absolute;
        top: 20px;
        right: 20px;
        width: 120px;
        height: 140px;
    }
    .logo-club img {
        width: 100%;
        height: 100%;
        object-fit: contain;
    }
    .main-content {
        margin-left: 160px;
        margin-right: 160px;
        padding-top: 10px;
    }
    .info-mono {
        font-family: monospace;
        white-space: pre;
        font-weight: bold;
        max-width: 700px;
        margin-bottom: 20px;
    }
    .table-wrapper {
        overflow-x: auto;
        border: 1px solid #ccc;
        padding: 5px;
    }
    table {
        border-collapse: collapse;
        width: 100%;
        margin-top: 10px;
        font-size: 13px;
    }
    th, td {
        border: 1px solid #000;
        padding: 6px 8px;
        text-align: center;
        vertical-align: middle;
        min-width: 45px;
        max-width: 55px;
    }
    th {
        background-color: #ddd;
    }
    button {
        margin-top: 20px;
        cursor: pointer;
        padding: 8px 14px;
        font-weight: bold;
        font-size: 14px;
        border-radius: 6px;
        border: none;
        background-color: #007BFF;
        color: white;
    }
    button:hover {
        background-color: #0056b3;
    }
    .btn-back {
        background-color: #6c757d;
        margin-right: 10px;
    }

@media print {
    button, form { display: none; }

    .header-wrapper {
        flex-direction: row;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
    }

    .foto-siswa, .logo-club {
        width: 80px !important;
        height: auto !important;
        margin: 0 !important;
    }

    .logo-club {
        margin-right: -10px !important; /* ✅ Tarik sedikit ke kiri */
    }

    .foto-siswa img,
    .logo-club img {
        width: 100%;
        height: auto;
        object-fit: contain;
    }

    .main-content {
        margin: 0;
    }

    .info-mono {
        padding-left: 30px !important;
    }
}



</style>
</head>
<body>

<div class="header-wrapper">
    <div class="foto-siswa">
        <?php
        $foto_path = '../uploads/foto/' . $siswa['nomor_registrasi'] . '.jpg';
        if (file_exists($foto_path)) {
            echo '<img src="' . htmlspecialchars($foto_path) . '" alt="Foto Siswa">';
        } else {
            echo '<div style="width:100%; height:100px; display:flex; justify-content:center; align-items:center; font-size:12px; color:#666;">No Photo</div>';
        }

        $sabuk_file = '../sabuk/' . formatSabukImgName($siswa['sabuk'] ?? 'putih') . '.png';
        if (file_exists($sabuk_file)) {
            echo '<img class="sabuk-img" src="' . htmlspecialchars($sabuk_file) . '" alt="Sabuk ' . htmlspecialchars($siswa['sabuk']) . '">';
        } else {
            echo '<div style="font-size:12px; color:#666; text-align:center;">Sabuk: ' . htmlspecialchars($siswa['sabuk'] ?? 'Putih') . '</div>';
        }
        ?>
    </div>
    <div class="logo-club">
        <img src="../momentum.png" alt="Logo Club">
    </div>
</div>

<div class="main-content">
    <h2>Laporan Absensi Siswa</h2>
    <h3><?= htmlspecialchars($siswa['nama_lengkap']) ?> (<?= htmlspecialchars($siswa['nomor_registrasi']) ?>)</h3>

    <div class="info-mono">
<?php
echo "Dojang  : " . ($dojang_map[$siswa['kode_dojang']] ?? 'Unknown Dojang') . "\n";
echo "Nama    : " . $siswa['nama_lengkap'] . "\n";
echo "Alamat  : " . str_replace("\n", "\n         ", $siswa['alamat_lengkap']) . "\n";
echo "No. HP  : " . $siswa['no_hp'] . "\n";
echo "T.T.L   : " . $ttl_formatted . "\n";
echo "Nomor Sertifikat : " . $nomor_sertifikat . "\n";
?>
    </div>

    <form method="GET" action="" style="text-align:center; margin-bottom: 15px;">
        <input type="hidden" name="nomor" value="<?= htmlspecialchars($nomor) ?>">
        <label for="tahun">Pilih Tahun: </label>
        <select name="tahun" id="tahun" onchange="this.form.submit()">
            <?php foreach ($years as $yr): ?>
                <option value="<?= $yr ?>" <?= ($yr == $tahun_selected) ? 'selected' : '' ?>><?= $yr ?></option>
            <?php endforeach; ?>
        </select>
    </form>

    <div class="table-wrapper">
        <table>
            <thead>
                <tr>
                    <th>Bulan</th>
                    <?php foreach ($angka_romawi as $romawi): ?>
                        <th><?= $romawi ?></th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody>
                <?php for ($b = 1; $b <= 12; $b++): ?>
                    <tr>
                        <td style="text-align:left; padding-left: 10px;"><?= $nama_bulan[$b] ?></td>
                        <?php for ($p = 1; $p <= 8; $p++): ?>
                            <td>
                                <?php
                                $user = $absensi[$b][$p];
                                $imgPath = "../paraf/" . htmlspecialchars($user) . ".png";
                                if ($user && file_exists($imgPath)) {
                                    echo '<img src="' . $imgPath . '" alt="Paraf" style="max-height:30px; max-width:50px;">';
                                } else {
                                    echo htmlspecialchars($user) ?: '-';
                                }
                                ?>
                            </td>
                        <?php endfor; ?>
                    </tr>
                <?php endfor; ?>
            </tbody>
        </table>
    </div>

    <div style="text-align:center; margin-top: 20px;">
        <button class="btn-back" onclick="window.location.href='dashboard.php'">Kembali ke Dashboard</button>
        <button onclick="window.print()">Cetak Laporan</button>
    </div>
</div>

</body>
</html>
