<?php
include '../db.php';

// Ambil data surat ujian id=1
$stmt = $pdo->prepare("SELECT * FROM surat_ujian WHERE id = 1");
$stmt->execute();
$surat = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$surat) {
    die("Data surat ujian tidak ditemukan. Silakan update terlebih dahulu.");
}

// Format tanggal surat, ujian, dan batas pengumpulan (Indonesian style)
function formatTanggalIndo($dateStr) {
    $months = [1=>'Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember'];
    $d = new DateTime($dateStr);
    return $d->format('d').' '.$months[(int)$d->format('m')].' '.$d->format('Y');
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Surat Resmi Ujian Kenaikan Tingkat</title>
<style>
  body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: #fff;
    color: #222;
    margin: 0;
    padding: 20px;
    line-height: 1.6;
  }
  .container {
    width: 216mm; /* US Legal Width */
    max-width: 100%;
    height: auto; /* supaya gak forcing height */
    margin: 0 auto;
    padding: 120px 40px 40px 40px; /* turunin padding atas biar muat satu halaman */
    background-color: rgba(255,255,255,0.9);
    background-image: url('../assets/images/surat.png');
    background-repeat: no-repeat;
    background-position: top center;
    background-size: contain;
    box-shadow: 0 0 15px rgba(0,0,0,0.1);
    border-radius: 8px;
    box-sizing: border-box;
  }
  .header-top {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    font-size: 12px;
  }
  .header-left div {
    margin-bottom: 6px;
  }
  .header-left div span {
    font-weight: 700;
    min-width: 80px;
    display: inline-block;
  }
  .header-right {
    text-align: right;
  }
  .kepada {
    margin-top: 0;
    margin-bottom: 25px;
    font-size: 12px;
    text-align: right;
  }
  .kepada p {
    margin: 3px 0;
  }
  .body-text {
    text-align: justify;
    font-size: 12px;
  }
  .body-text p {
    margin-bottom: 1em;
  }
  .body-text ul {
    margin-left: 20px;
    margin-bottom: 1em;
  }
  .body-text ul li {
    margin-bottom: 0.4em;
  }
  .signature {
    margin-top: 50px;
    text-align: left;
    font-size: 12px;
  }
  .signature .name {
    margin-top: 80px;
    font-weight: 700;
    text-decoration: underline;
  }
  .print-btn {
    margin: 20px 0;
    display: flex;
    justify-content: center;
  }
  button.print {
    padding: 10px 25px;
    font-size: 14px;
    cursor: pointer;
    background-color: #007BFF;
    border: none;
    color: white;
    border-radius: 5px;
  }
  button.print:hover {
    background-color: #0056b3;
  }

  /* Print Styles */
  @media print {
    @page {
      size: legal portrait;
      margin: 0;
    }
    body, html {
      margin: 0;
      padding: 10mm;
      -webkit-print-color-adjust: exact !important; /* Chrome/Safari */
      print-color-adjust: exact !important;
      height: 100%;
    }
    .container {
      width: 216mm;
      max-width: 100%;
      height: auto !important;
      margin: 0;
      padding: 120px 40px 40px 40px !important;
      background-color: rgba(255,255,255,0.9) !important;
      background-image: url('../assets/images/surat.png') !important;
      background-repeat: no-repeat !important;
      background-position: top center !important;
      background-size: contain !important;
      box-shadow: none !important;
      border-radius: 0 !important;
      box-sizing: border-box !important;
      page-break-after: avoid;
      page-break-inside: avoid;
    }
    .print-btn {
      display: none !important;
    }
  }
</style>
</head>
<body>
<div class="container">
  <div class="header-top">
    <div class="header-left">
      <div><span>No</span>: <?=htmlspecialchars($surat['nomor_surat'])?></div>
      <div><span>Lamp</span>: 1 lembar</div>
      <div><span>Hal</span>: Ujian Kenaikan Tingkat</div>
    </div>
    <div class="header-right">
      <?=htmlspecialchars($surat['tanggal_surat']) ? formatTanggalIndo($surat['tanggal_surat']) : ''?>
    </div>
  </div>

  <div class="kepada">
    <p>Kepada Yth :</p>
    <p>Orang Tua/ Wali</p>
    <p>Tae Kwon Do-in</p>
    <p>Di Tempat</p>
  </div>

  <div class="body-text">
    <p>Dengan Hormat,</p>
    <p>
      Sehubungan dengan Program Kerja Tae Kwon Do Momentum Club yang meliputi Unit SDS TIARA SCHOOL, SMP N 6, Balai Warga, SMA N 107 dan East Park Apartment. Dengan ini kami mengadakan Ujian Kenaikan Tingkat untuk priode I tahun <?=date('Y')?>. Adapun waktu pelaksanaanya pada:
    </p>
    <p>
      <strong>Hari dan Tanggal</strong>: <?=htmlspecialchars($surat['tanggal_ujian']) ? formatTanggalIndo($surat['tanggal_ujian']) : ''?><br />
      <strong>Waktu</strong>: <?=htmlspecialchars($surat['waktu_ujian'])?><br />
      <strong>Tempat</strong>: Gedung Balai Warga RW 09 Pondok Kelapa
    </p>
    <p>
      Kepada setiap calon peserta ujian kenaikan tingkat diharuskan melengkapi persyaratan sebagai berikut:
    </p>
    <ul>
      <li>Mengisi formulir ujian lengkap dengan no. certificate (kecuali sabuk putih)</li>
      <li>Menyerahkan Absensi latihan siswa yang telah diisi minimal 2 bulan</li>
      <li>Pas photo 3 x 4 sebanyak 4 lembar dengan menggunakan Dobok (Seragam Latihan)</li>
      <li>Melunasi iuran sampai dengan <?=htmlspecialchars($surat['lunas_iuran'])?></li>
      <li>Membayar biaya kenaikan tingkat sebesar:
        <ul>
          <li>Sabuk putih (Geup X) Rp 400.000</li>
          <li>Sabuk Kuning - Kuning Strip Hijau (Geup IX - VIII) Rp 430.000</li>
          <li>Sabuk Hijau - Hijau Strip Biru (Geup VII - VI) Rp 450.000</li>
          <li>Sabuk Biru - Biru Strip Merah (Geup V - IV) Rp 500.000</li>
          <li>Sabuk Merah - Merah Strp Hitam I (Geup III - II) Rp 650.000</li>
        </ul>
      </li>
    </ul>
    <p>
      Kelengkapan peserta yaitu MELUNASI IURAN SAMPAI BULAN <?=htmlspecialchars($surat['lunas_iuran'])?> dan melengkapi selambat-lambatnya untuk mengumpulkan berkas pada hari <?=htmlspecialchars($surat['batas_berkas']) ? formatTanggalIndo($surat['batas_berkas']) : ''?>. Apabila calon peserta telat mendaftar dan mengumpulkan berkas dikenakan denda sebesar Rp.50.000,- dan bagi peserta ujian dilarang meninggalkan tempat ujian sebelum acara Upacara Penutupan.
    </p>
    <p>
      Atas perhatiannya dan kerja samanya kami atas nama pengurus, pelatih, dan Dewan Guru mengucapkan terima kasih.
    </p>
  </div>

  <div class="signature">
    <p>Hormat Kami,</p>
    <p>Ketua Tae Kwon Do<br />Momentum Club</p>
    <p class="name">(Fernando Sinisuka, S.H)</p>
  </div>

  <div class="print-btn">
    <button class="print" onclick="window.print()">Cetak Surat</button>
  </div>
</div>
</body>
</html>
