<?php
include 'db.php';

function formatTanggalLahir($tempat_tgl) {
    $parts = explode(',', $tempat_tgl);
    if (count($parts) != 2) return $tempat_tgl;

    $tempat = trim($parts[0]);
    $tgl = trim($parts[1]);

    $dateObj = DateTime::createFromFormat('d-m-Y', $tgl);
    if (!$dateObj) return $tempat_tgl;

    $bulanIndo = [
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    ];
    $tglFormatted = $dateObj->format('d') . ' ' . $bulanIndo[(int)$dateObj->format('m')] . ' ' . $dateObj->format('Y');

    return $tempat . ', ' . $tglFormatted;
}

$nomor = $_GET['nomor'] ?? '';
if (!$nomor) die('Nomor registrasi siswa belum diberikan.');

$tahun_selected = $_GET['tahun'] ?? date('Y');

$stmt = $pdo->prepare("SELECT * FROM siswa WHERE nomor_registrasi = ?");
$stmt->execute([$nomor]);
$siswa = $stmt->fetch();
if (!$siswa) die('Data siswa tidak ditemukan.');

$dojang_map = [
    'BWPK' => 'Balai Warga Pondok Kelapa',
    'SDTS' => 'SD Tiara School',
    'SDTK' => 'SD Tunas Karya 2',
    'SMP6' => 'SMPN 6 Jakarta',
    'SMA107' => 'SMAN 107 Jakarta',
    'EPA' => 'East Park Apartment',
    'RBHIN' => 'RPTRA Bhineka (EPRA)',
    'ALAC' => 'Alhuda Academy (EPRA)',
    'PKB' => 'Pakubuwono (EPRA)',
    'SBSD' => 'Sekolah Sinarmas BSD',
    'PRV' => 'Private',
    'TMMLK' => 'Taman Malaka'
];

$ttl_formatted = formatTanggalLahir($siswa['tempat_tgl_lahir']);

$stmt = $pdo->prepare("
    SELECT tanggal, pertemuan, paraf_pelatih
    FROM absensi
    WHERE nomor_registrasi = ? AND YEAR(tanggal) = ?
");
$stmt->execute([$nomor, $tahun_selected]);
$absensi_raw = $stmt->fetchAll(PDO::FETCH_ASSOC);

$absensi = [];
for ($b=1; $b<=12; $b++) {
    for ($p=1; $p<=8; $p++) {
        $absensi[$b][$p] = '';
    }
}
foreach ($absensi_raw as $row) {
    $bulan = (int)date('n', strtotime($row['tanggal']));
    $pertemuan = (int)$row['pertemuan'];
    if ($pertemuan >=1 && $pertemuan <=8) {
        $absensi[$bulan][$pertemuan] = $row['paraf_pelatih'];
    }
}

$nama_bulan = [
    1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
    'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
];

$angka_romawi = ['I', 'II', 'III', 'IV', 'V', 'VI', 'VII', 'VIII'];

$current_year = date('Y');
$year_start = 2020;
$years = range($year_start, $current_year);
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<title>Laporan Absensi Tahun <?= htmlspecialchars($tahun_selected) ?> - <?= htmlspecialchars($siswa['nama_lengkap']) ?></title>
<style>
    body {
        font-family: Arial, sans-serif;
        margin: 30px;
        position: relative;
    }
    h2, h3 {
        text-align: center;
        margin-bottom: 0;
    }
    .foto-siswa {
        position: absolute;
        top: 20px;
        left: 20px;
        width: 120px;
        height: 140px;
        border: 1px solid #000;
        padding: 5px;
    }
    .foto-siswa img {
        width: 100%;
        height: 100%;
        object-fit: contain;
        background: #f0f0f0;
    }
    .logo-club {
        position: absolute;
        top: 20px;
        right: 20px;
        width: 120px;
        height: 140px;
    }
    .logo-club img {
        width: 100%;
        height: 100%;
        object-fit: contain;
    }
    .main-content {
        margin-left: 160px;
        margin-right: 160px;
        padding-top: 10px;
    }
    .info-mono {
        font-family: monospace;
        white-space: pre;
        font-weight: bold;
        max-width: 700px;
        margin-bottom: 20px;
    }
    .table-wrapper {
        overflow-x: auto;
        border: 1px solid #ccc;
        padding: 5px;
    }
    table {
        border-collapse: collapse;
        width: 100%;
        margin-top: 10px;
        font-size: 13px;
    }
    th, td {
        border: 1px solid #000;
        padding: 6px 8px;
        text-align: center;
        vertical-align: middle;
        word-break: break-word;
        min-width: 45px;
        max-width: 55px;
    }
    th {
        background-color: #ddd;
        font-weight: bold;
    }
    button {
        margin-top: 20px;
    }
    @media print {
        button, form { display: none; }
    }
</style>
</head>
<body>

<div class="foto-siswa">
    <?php
    $foto = $siswa['foto'] ?? '';
    if ($foto) {
        if (filter_var($foto, FILTER_VALIDATE_URL)) {
            $foto_src = $foto;
        } else {
            $foto_src = htmlspecialchars($foto);
        }
        echo '<img src="' . $foto_src . '" alt="Foto Siswa">';
    } else {
        echo '<div style="width:100%; height:100%; display:flex; justify-content:center; align-items:center; font-size:12px; color:#666;">No Photo</div>';
    }
    ?>
</div>

<div class="logo-club">
    <img src="momentum.png" alt="Logo Club">
</div>

<div class="main-content">
    <h2>Laporan Absensi Siswa</h2>
    <h3><?= htmlspecialchars($siswa['nama_lengkap']) ?> (<?= htmlspecialchars($siswa['nomor_registrasi']) ?>)</h3>

    <div class="info-mono">
<?php
echo "Dojang  : " . ($dojang_map[$siswa['kode_dojang']] ?? 'Unknown Dojang') . "\n";
echo "Nama    : " . $siswa['nama_lengkap'] . "\n";
echo "Alamat  : " . str_replace("\n", "\n         ", $siswa['alamat_lengkap']) . "\n";
echo "No. HP  : " . $siswa['no_hp'] . "\n";
echo "T.T.L   : " . $ttl_formatted . "\n";
?>
    </div>

    <form method="GET" action="" style="text-align:center; margin-bottom: 15px;">
        <input type="hidden" name="nomor" value="<?= htmlspecialchars($nomor) ?>">
        <label for="tahun">Pilih Tahun: </label>
        <select name="tahun" id="tahun" onchange="this.form.submit()">
            <?php foreach ($years as $yr): ?>
                <option value="<?= $yr ?>" <?= ($yr == $tahun_selected) ? 'selected' : '' ?>><?= $yr ?></option>
            <?php endforeach; ?>
        </select>
        <noscript><input type="submit" value="Tampilkan"></noscript>
    </form>

    <div class="table-wrapper">
        <table>
            <thead>
                <tr>
                    <th>Bulan</th>
                    <?php foreach ($angka_romawi as $romawi): ?>
                        <th><?= $romawi ?></th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody>
                <?php for ($b=1; $b<=12; $b++): ?>
                    <tr>
                        <td style="text-align:left; padding-left: 10px;"><?= $nama_bulan[$b] ?></td>
                        <?php for ($p=1; $p<=8; $p++): ?>
                            <td><?= htmlspecialchars($absensi[$b][$p]) ?: '-' ?></td>
                        <?php endfor; ?>
                    </tr>
                <?php endfor; ?>
            </tbody>
        </table>
    </div>

    <button onclick="window.print()">Cetak Laporan</button>
</div>

</body>
</html>
